/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.handler.BarOverlayRenderer;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class ArmorBarRenderer {
    public static void renderArmorBar(GuiGraphics guiGraphics, int posX, int posY, Player player, ProfilerFiller profiler, boolean unmodified) {
        profiler.m_6180_("armor");
        ClientConfig.ArmorRowConfig config = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor;
        int armorPoints = player.m_21230_();
        ArmorBarRenderer.renderArmorBar(guiGraphics, posX, posY, 18, armorPoints, true, unmodified, config);
        profiler.m_7238_();
    }

    public static void renderToughnessBar(GuiGraphics guiGraphics, int posX, int posY, Player player, ProfilerFiller profiler, boolean left, boolean unmodified) {
        profiler.m_6180_("toughness");
        ClientConfig.ToughnessRowConfig config = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness;
        int armorPoints = Mth.m_14107_((double)player.m_21133_(Attributes.f_22285_));
        ArmorBarRenderer.renderArmorBar(guiGraphics, posX, posY, left ? 9 : 0, armorPoints, left, unmodified, config);
        profiler.m_7238_();
    }

    public static void renderArmorBar(GuiGraphics guiGraphics, int posX, int posY, int vOffset, int armorPoints, boolean left, boolean unmodified, ClientConfig.ArmorRowConfig config) {
        if (armorPoints <= 0) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        boolean inverse = !unmodified && config.inverseColoring;
        boolean skip = !unmodified && config.skipEmptyArmorPoints;
        int lastRowArmorPoints = 0;
        if (!unmodified && (config.colorizeFirstRow || armorPoints > 20)) {
            lastRowArmorPoints = (armorPoints - 1) % 20 + 1;
        }
        for (int currentArmorPoint = 0; currentArmorPoint < 10; ++currentArmorPoint) {
            int startX = posX + (left ? currentArmorPoint * 8 : -currentArmorPoint * 8 - 9);
            if (currentArmorPoint * 2 + 1 < lastRowArmorPoints) {
                guiGraphics.m_280163_(BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, startX, posY, inverse ? 18.0f : 36.0f, (float)vOffset, 9, 9, 256, 256);
                continue;
            }
            if (currentArmorPoint * 2 + 1 == lastRowArmorPoints) {
                if (armorPoints > 20) {
                    guiGraphics.m_280163_(BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, startX, posY, inverse ? 54.0f : 27.0f, (float)vOffset, 9, 9, 256, 256);
                    continue;
                }
                guiGraphics.m_280163_(BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, startX, posY, inverse ? 9.0f : 45.0f, (float)vOffset, 9, 9, 256, 256);
                continue;
            }
            if (currentArmorPoint * 2 + 1 < armorPoints) {
                guiGraphics.m_280163_(BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, startX, posY, inverse ? 36.0f : 18.0f, (float)vOffset, 9, 9, 256, 256);
                continue;
            }
            if (currentArmorPoint * 2 + 1 == armorPoints) {
                guiGraphics.m_280163_(BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, startX, posY, inverse ? 45.0f : 9.0f, (float)vOffset, 9, 9, 256, 256);
                continue;
            }
            if (skip || currentArmorPoint * 2 + 1 <= armorPoints) continue;
            guiGraphics.m_280163_(BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, startX, posY, 0.0f, (float)vOffset, 9, 9, 256, 256);
        }
    }
}

