/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceMovement;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAPartials;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PortableEnergyInterfaceRenderer
extends SafeBlockEntityRenderer<PortableEnergyInterfaceBlockEntity> {
    public PortableEnergyInterfaceRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(PortableEnergyInterfaceBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        BlockState blockState = be.m_58900_();
        float progress = be.getExtensionDistance(partialTicks);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        PortableEnergyInterfaceRenderer.render(blockState, be.isConnected(), progress, null, sbb -> sbb.light(light).renderInto(ms, vb));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockState blockState = context.state;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        LerpedFloat animation = PortableEnergyInterfaceMovement.getAnimation(context);
        float progress = animation.getValue(renderPartialTicks);
        boolean lit = animation.settled();
        PortableEnergyInterfaceRenderer.render(blockState, lit, progress, matrices.getModel(), sbb -> sbb.light(LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb));
    }

    private static void render(BlockState blockState, boolean lit, float progress, PoseStack local, Consumer<SuperByteBuffer> drawCallback) {
        SuperByteBuffer middle = CachedBuffers.partial((PartialModel)PortableEnergyInterfaceRenderer.getMiddleForState(blockState, lit), (BlockState)blockState);
        SuperByteBuffer top = CachedBuffers.partial((PartialModel)PortableEnergyInterfaceRenderer.getTopForState(blockState), (BlockState)blockState);
        if (local != null) {
            middle.transform(local);
            top.transform(local);
        }
        Direction facing = (Direction)blockState.m_61143_((Property)PortableEnergyInterfaceBlock.f_52588_);
        PortableEnergyInterfaceRenderer.rotateToFacing(middle, facing);
        PortableEnergyInterfaceRenderer.rotateToFacing(top, facing);
        middle.translate(0.0f, progress * 0.5f + 0.375f, 0.0f);
        top.translate(0.0f, progress, 0.0f);
        drawCallback.accept(middle);
        drawCallback.accept(top);
    }

    private static void rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(facing == Direction.UP ? 0.0f : (facing == Direction.DOWN ? 180.0f : 90.0f))).uncenter();
    }

    static PortableEnergyInterfaceBlockEntity getTargetPSI(MovementContext context) {
        String _workingPos_ = "WorkingPos";
        if (!context.data.m_128441_(_workingPos_)) {
            return null;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)context.data.m_128469_(_workingPos_));
        BlockEntity blockEntity = context.world.m_7702_(pos);
        if (!(blockEntity instanceof PortableEnergyInterfaceBlockEntity)) {
            return null;
        }
        PortableEnergyInterfaceBlockEntity psi = (PortableEnergyInterfaceBlockEntity)blockEntity;
        if (!psi.isTransferring()) {
            return null;
        }
        return psi;
    }

    static PartialModel getMiddleForState(BlockState state, boolean lit) {
        CABlocks.PORTABLE_ENERGY_INTERFACE.has(state);
        return lit ? CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE_POWERED : CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE;
    }

    static PartialModel getTopForState(BlockState state) {
        return CAPartials.PORTABLE_ENERGY_INTERFACE_TOP;
    }
}

