/*
 * Decompiled with CFR 0.152.
 */
package net.lulaboludo.createornithopterglider.registry;

import java.util.UUID;
import net.lulaboludo.createornithopterglider.item.custom.OrnithopterGliderItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="createornithopterglider")
public class ModEvents {
    public static final UUID ORNITHOPTER_FLIGHT_MODIFIER_ID = UUID.fromString("7d2b1dc2-d298-459c-b94b-112a53c0a84c");
    public static final AttributeModifier ORNITHOPTER_FLIGHT = new AttributeModifier(ORNITHOPTER_FLIGHT_MODIFIER_ID, "ornithopter_flight", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AttributeInstance attributeInstance;
        Player player = event.player;
        if (event.phase == TickEvent.Phase.START && (attributeInstance = player.m_21051_(CaelusApi.getInstance().getFlightAttribute())) != null) {
            boolean hasOrnithopter = ModEvents.isOrnithopterInCurios(player);
            if (attributeInstance.m_22109_(ORNITHOPTER_FLIGHT)) {
                if (!hasOrnithopter) {
                    attributeInstance.m_22130_(ORNITHOPTER_FLIGHT);
                }
            } else if (hasOrnithopter) {
                attributeInstance.m_22118_(ORNITHOPTER_FLIGHT);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        AttributeInstance attributeInstance = player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
        if (attributeInstance != null && ModEvents.isOrnithopterInCurios(player) && !attributeInstance.m_22109_(ORNITHOPTER_FLIGHT)) {
            attributeInstance.m_22118_(ORNITHOPTER_FLIGHT);
        }
    }

    private static boolean isOrnithopterInCurios(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.isEquipped(stack -> stack.m_41720_() instanceof OrnithopterGliderItem)).orElse(false);
    }
}

