/*
 * Decompiled with CFR 0.152.
 */
package net.lulaboludo.createornithopterglider.registry;

import com.mojang.blaze3d.vertex.PoseStack;
import net.lulaboludo.createornithopterglider.client.animations.FlapAnimationManager;
import net.lulaboludo.createornithopterglider.client.animations.OrnithoptergGliderAnimation;
import net.lulaboludo.createornithopterglider.item.custom.OrnithopterGliderItem;
import net.lulaboludo.createornithopterglider.networking.ModMessages;
import net.lulaboludo.createornithopterglider.networking.packets.BoostGliderPacket;
import net.lulaboludo.createornithopterglider.sounds.ModSounds;
import net.lulaboludo.createornithopterglider.util.KeyBinding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class BoostGliderEvents {
    public static boolean charging = false;
    public static int chargeTicks = 0;
    public static int overflowTicks = 0;
    public static final int MAX_CHARGE = 30;
    public static final int DECAY_TIME = 2;
    public static final int DECAY_PIXELS = 30;
    public static final int COOLDOWN_TICKS = 40;
    public static int cooldownTicks = 0;
    public static int cooldownDisplayDelay = 0;
    static final ResourceLocation FILL = new ResourceLocation("createornithopterglider", "textures/gui/boost_bar.png");
    static final ResourceLocation BG = new ResourceLocation("createornithopterglider", "textures/gui/boost_bar_background.png");
    static final ResourceLocation ICON = new ResourceLocation("createornithopterglider", "textures/gui/boost_icon.png");
    static final int BG_WIDTH = 186;
    static final int BG_HEIGHT = 22;
    static final int FILL_WIDTH = 182;
    static final int FILL_HEIGHT = 5;
    static final float TEXT_SCALE = 0.6f;
    static final int ICON_SIZE = 8;

    private static void drawString(GuiGraphics guiGraphics, Minecraft mc, String text, int xText, int yText) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.6f, 0.6f, 1.0f);
        guiGraphics.drawString(mc.f_91062_, text, (float)xText / 0.6f, (float)yText / 0.6f, -1, true);
        poseStack.m_85849_();
    }

    private static int getFilled() {
        int filled;
        if (chargeTicks < 30) {
            filled = (int)((float)chargeTicks / 30.0f * 182.0f);
        } else {
            float t = (float)overflowTicks / 2.0f;
            int decay = Math.round(t * 30.0f);
            filled = 182 - decay;
        }
        return filled;
    }

    @Mod.EventBusSubscriber(modid="createornithopterglider", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class KeyBoostOverlay {
        @SubscribeEvent
        public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.JUMP_BAR.id(), "boost_charge", (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
                int filled;
                Minecraft mc = Minecraft.m_91087_();
                if (!OrnithopterGliderItem.isFlying((Player)mc.f_91074_)) {
                    return;
                }
                int x = (screenWidth - 186) / 2;
                int y = screenHeight - 42;
                guiGraphics.m_280163_(BG, x, y, 0.0f, 0.0f, 186, 22, 186, 22);
                int xIcon = (screenWidth - 8) / 2;
                int yIcon = y + 4;
                if (cooldownTicks > 0) {
                    if (cooldownDisplayDelay >= 8) {
                        float secondsLeft = (float)cooldownTicks / 20.0f;
                        String text = String.format("%.1f", Float.valueOf(secondsLeft));
                        int textW = mc.f_91062_.m_92895_(text);
                        int xText = (screenWidth - textW) / 2 + 3;
                        int yText = y + 6;
                        BoostGliderEvents.drawString(guiGraphics, mc, text, xText, yText);
                    } else {
                        guiGraphics.m_280163_(ICON, xIcon, yIcon, 0.0f, 0.0f, 8, 8, 8, 8);
                    }
                    return;
                }
                guiGraphics.m_280163_(ICON, xIcon, yIcon, 0.0f, 0.0f, 8, 8, 8, 8);
                if (charging && (filled = BoostGliderEvents.getFilled()) > 0) {
                    int fillX = x + 2;
                    int fillY = y + 14;
                    guiGraphics.m_280163_(FILL, fillX, fillY, 0.0f, 0.0f, filled, 5, 182, 5);
                }
            });
        }
    }

    @Mod.EventBusSubscriber(modid="createornithopterglider", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class KeyBoostHandler {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (cooldownTicks > 0) {
                ++cooldownDisplayDelay;
                if (--cooldownTicks == 0) {
                    cooldownDisplayDelay = 0;
                }
                return;
            }
            if (!OrnithopterGliderItem.isFlying((Player)mc.f_91074_)) {
                return;
            }
            if (KeyBinding.BOOST_KEY.m_90857_()) {
                if (!charging) {
                    charging = true;
                    chargeTicks = 0;
                    overflowTicks = 0;
                }
                if (chargeTicks < 30) {
                    ++chargeTicks;
                } else {
                    overflowTicks = Math.min(overflowTicks + 1, 2);
                }
            } else if (charging) {
                float percent = (float)BoostGliderEvents.getFilled() / 182.0f;
                float curve = (float)Math.pow(percent, 2.0);
                int force = Math.round(curve * 30.0f);
                ModMessages.sendToServer(new BoostGliderPacket(force));
                FlapAnimationManager.playAnimation((Player)mc.f_91074_, OrnithoptergGliderAnimation.OG_GLIDING_FLAP);
                mc.f_91074_.m_9236_().m_214150_((Player)mc.f_91074_, mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), (SoundEvent)ModSounds.WING_FLAPPING.get(), SoundSource.PLAYERS, 10.0f, 1.0f, 0L);
                charging = false;
                cooldownTicks = 40;
            }
        }

        @SubscribeEvent
        public static void onOverlayPre(RenderGuiOverlayEvent.Pre event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id()) && OrnithopterGliderItem.isFlying((Player)player)) {
                event.setCanceled(true);
            }
        }
    }
}

