/*
 * Decompiled with CFR 0.152.
 */
package net.lulaboludo.createornithopterglider.client.animations;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.world.entity.player.Player;

public class FlapAnimationManager {
    private static final Map<Player, AnimationData> animationMap = new HashMap<Player, AnimationData>();

    public static void playAnimation(Player player, AnimationDefinition animation) {
        animationMap.put(player, new AnimationData(animation, System.currentTimeMillis()));
    }

    public static AnimationDefinition getAnimation(Player player) {
        AnimationData data = animationMap.get(player);
        if (data == null) {
            return null;
        }
        long elapsed = System.currentTimeMillis() - data.startTime;
        if ((float)elapsed < data.animation.f_232255_() * 1000.0f) {
            return data.animation;
        }
        animationMap.remove(player);
        return null;
    }

    public static long getElapsedTicks(Player player) {
        AnimationData data = animationMap.get(player);
        if (data == null) {
            return 0L;
        }
        long elapsedMillis = System.currentTimeMillis() - data.startTime;
        return elapsedMillis * 20L / 1000L;
    }

    private static class AnimationData {
        AnimationDefinition animation;
        long startTime;

        public AnimationData(AnimationDefinition animation, long startTime) {
            this.animation = animation;
            this.startTime = startTime;
        }
    }
}

