/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackUUIDArgumentType;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class GiveCommand {
    private GiveCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"backpackUuid", (ArgumentType)BackpackUUIDArgumentType.backpackUuid()).executes(context -> GiveCommand.giveBackpack((CommandSourceStack)context.getSource(), (UUID)context.getArgument("backpackUuid", UUID.class), EntityArgument.m_91477_((CommandContext)context, (String)"targets")))));
    }

    private static int giveBackpack(CommandSourceStack source, UUID backpackUuid, Collection<ServerPlayer> players) {
        BackpackAccessLogger.getBackpackLog(backpackUuid).ifPresent(alr -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(alr.getBackpackItemRegistryName());
            ItemStack backpack = new ItemStack((ItemLike)item);
            if (!backpack.m_41786_().getString().equals(alr.getBackpackName())) {
                backpack.m_41714_((Component)Component.m_237113_((String)alr.getBackpackName()));
            }
            backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
                backpackWrapper.setColors(alr.getClothColor(), alr.getTrimColor());
                backpackWrapper.setColumnsTaken(alr.getColumnsTaken(), false);
                backpackWrapper.setContentsUuid(backpackUuid);
            });
            players.forEach(p -> GiveCommand.giveBackpackToPlayer(backpack, p));
            if (players.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.give.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.give.success", (Object[])new Object[]{players.size()}), true);
            }
        });
        return 0;
    }

    private static void giveBackpackToPlayer(ItemStack backpack, ServerPlayer p) {
        ItemEntity itemEntity;
        boolean flag = p.m_150109_().m_36054_(backpack);
        if (flag && backpack.m_41619_()) {
            backpack.m_41764_(1);
            itemEntity = p.m_36176_(backpack, false);
            if (itemEntity != null) {
                itemEntity.m_32065_();
            }
            p.m_9236_().m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)p.m_217043_()) * 0.7f + 1.0f) * 2.0f);
            p.f_36095_.m_38946_();
        } else {
            ItemEntity itementity = p.m_36176_(backpack, false);
            if (itementity != null) {
                itementity.m_32061_();
                itementity.m_32052_(p.m_20148_());
            }
        }
        itemEntity = p.m_36176_(backpack, false);
        if (itemEntity != null) {
            itemEntity.m_32065_();
        }
    }
}

