/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.mixin.accessor.ConcretePowderBlockAccessor;
import com.simibubi.create.foundation.pack.DynamicPack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ConcretePowderBlock;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RuntimeDataGenerator {
    private static final Pattern STRIPPED_WOODS_PREFIX_REGEX = Pattern.compile("(\\w*)??stripped_(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)()$");
    private static final Pattern STRIPPED_WOOD_SUFFIX_REGEX = Pattern.compile("(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)(\\w*)_stripped(\\w*)");
    private static final Pattern NON_STRIPPED_WOODS_REGEX = Pattern.compile("^(?!stripped_)([a-z_]+)(_log|_wood|_stem|_hyphae|(?<!bioshroom)_block)(([a-z_]+)(?<!_stripped))?$");
    private static final Multimap<ResourceLocation, TagEntry> TAGS = HashMultimap.create();
    private static final Object2ObjectOpenHashMap<ResourceLocation, JsonObject> JSON_FILES = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, ResourceLocation> MISMATCHED_WOOD_NAMES = ImmutableMap.builder().put((Object)Mods.ARS_N.asResource("blue_archwood"), (Object)Mods.ARS_N.asResource("archwood")).put((Object)Mods.DD.asResource("blooming"), (Object)Mods.DD.asResource("bloom")).build();

    public static void insertIntoPack(DynamicPack dynamicPack) {
        for (ResourceLocation resourceLocation : BuiltInRegistries.f_257033_.m_6566_()) {
            RuntimeDataGenerator.cuttingRecipes(resourceLocation);
            RuntimeDataGenerator.washingRecipes(resourceLocation);
        }
        Create.LOGGER.info("Created {} recipes which will be injected into the game", (Object)JSON_FILES.size());
        JSON_FILES.forEach(dynamicPack::put);
        Create.LOGGER.info("Created {} tags which will be injected into the game", (Object)TAGS.size());
        for (Map.Entry entry : TAGS.asMap().entrySet()) {
            TagFile tagFile = new TagFile(new ArrayList((Collection)entry.getValue()), false);
            dynamicPack.put(((ResourceLocation)entry.getKey()).m_246208_("tags/items/"), (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)tagFile).result().orElseThrow());
        }
        JSON_FILES.clear();
        JSON_FILES.trim();
        TAGS.clear();
    }

    private static void cuttingRecipes(ResourceLocation itemId) {
        boolean hasFoundMatch;
        String path = itemId.m_135815_();
        Matcher match = STRIPPED_WOODS_PREFIX_REGEX.matcher(path);
        boolean strippedInPrefix = hasFoundMatch = match.find();
        if (!hasFoundMatch) {
            match = STRIPPED_WOOD_SUFFIX_REGEX.matcher(path);
            hasFoundMatch = match.find();
        }
        boolean noStrippedVariant = false;
        if (!(hasFoundMatch || BuiltInRegistries.f_257033_.m_7804_(itemId.m_246208_("stripped_")) || BuiltInRegistries.f_257033_.m_7804_(itemId.m_266382_("_stripped")))) {
            match = NON_STRIPPED_WOODS_REGEX.matcher(path);
            hasFoundMatch = match.find();
            noStrippedVariant = true;
        }
        if (hasFoundMatch) {
            int planksCount;
            String prefix = strippedInPrefix && match.group(1) != null ? match.group(1) : "";
            String suffix = !strippedInPrefix && !noStrippedVariant ? match.group(3) + match.group(4) : "";
            String type = match.group(strippedInPrefix ? 3 : 2);
            ResourceLocation matched_name = itemId.m_247449_(match.group(strippedInPrefix ? 2 : 1));
            ResourceLocation base = matched_name.m_266382_(type.equals("wood") ? "wood" : "");
            base = MISMATCHED_WOOD_NAMES.getOrDefault(base, base);
            ResourceLocation nonStrippedId = matched_name.m_266382_(type).m_246208_(prefix).m_266382_(suffix);
            ResourceLocation planksId = base.m_266382_("_planks");
            ResourceLocation stairsId = base.m_266382_(base.m_135827_().equals(Mods.BTN.getId()) ? "_planks_stairs" : "_stairs");
            ResourceLocation slabId = base.m_266382_(base.m_135827_().equals(Mods.BTN.getId()) ? "_planks_slab" : "_slab");
            ResourceLocation fenceId = base.m_266382_("_fence");
            ResourceLocation fenceGateId = base.m_266382_("_fence_gate");
            ResourceLocation doorId = base.m_266382_("_door");
            ResourceLocation trapdoorId = base.m_266382_("_trapdoor");
            ResourceLocation pressurePlateId = base.m_266382_("_pressure_plate");
            ResourceLocation buttonId = base.m_266382_("_button");
            ResourceLocation signId = base.m_266382_("_sign");
            int n = planksCount = type.contains("block") ? 3 : 6;
            if (!noStrippedVariant) {
                RuntimeDataGenerator.simpleWoodRecipe(nonStrippedId, itemId);
                RuntimeDataGenerator.simpleWoodRecipe(itemId, planksId, planksCount);
            } else if (BuiltInRegistries.f_257033_.m_7804_(planksId)) {
                ResourceLocation tag = Create.asResource("runtime_generated/compat/" + itemId.m_135827_() + "/" + base.m_135815_());
                RuntimeDataGenerator.insertIntoTag(tag, itemId);
                RuntimeDataGenerator.simpleWoodRecipe((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag), planksId, planksCount);
            }
            if (!path.contains("_wood") && !path.contains("_hyphae") && BuiltInRegistries.f_257033_.m_7804_(planksId)) {
                RuntimeDataGenerator.simpleWoodRecipe(planksId, stairsId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, slabId, 2);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, fenceId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, fenceGateId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, doorId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, trapdoorId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, pressurePlateId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, buttonId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, signId);
            }
        }
    }

    private static void washingRecipes(ResourceLocation itemId) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(itemId);
        if (block instanceof ConcretePowderBlock) {
            ConcretePowderBlock concretePowderBlock = (ConcretePowderBlock)block;
            Block concreteBlock = ((ConcretePowderBlockAccessor)concretePowderBlock).create$getConcrete().m_60734_();
            RuntimeDataGenerator.simpleSplashingRecipe(itemId, BuiltInRegistries.f_256975_.m_7981_((Object)concreteBlock));
        }
    }

    private static void insertIntoTag(ResourceLocation tag, ResourceLocation itemId) {
        if (BuiltInRegistries.f_257033_.m_7804_(itemId)) {
            TAGS.put((Object)tag, (Object)TagEntry.m_215943_((ResourceLocation)itemId));
        }
    }

    private static void simpleWoodRecipe(ResourceLocation inputId, ResourceLocation outputId) {
        RuntimeDataGenerator.simpleWoodRecipe(inputId, outputId, 1);
    }

    private static void simpleWoodRecipe(ResourceLocation inputId, ResourceLocation outputId, int amount) {
        if (BuiltInRegistries.f_257033_.m_7804_(outputId)) {
            new Builder<CuttingRecipe>(inputId.m_135827_(), CuttingRecipe::new, inputId.m_135815_(), outputId.m_135815_()).require((ItemLike)BuiltInRegistries.f_257033_.m_7745_(inputId)).output((ItemLike)BuiltInRegistries.f_257033_.m_7745_(outputId), amount).duration(50).build();
        }
    }

    private static void simpleWoodRecipe(TagKey<Item> inputTag, ResourceLocation outputId, int amount) {
        if (BuiltInRegistries.f_257033_.m_7804_(outputId)) {
            new Builder<CuttingRecipe>(inputTag.f_203868_().m_135827_(), CuttingRecipe::new, "tag_" + inputTag.f_203868_().m_135815_(), outputId.m_135815_()).require(inputTag).output((ItemLike)BuiltInRegistries.f_257033_.m_7745_(outputId), amount).duration(50).build();
        }
    }

    private static void simpleSplashingRecipe(ResourceLocation first, ResourceLocation second) {
        new Builder<SplashingRecipe>(first.m_135827_(), SplashingRecipe::new, first.m_135815_(), second.m_135815_()).require((ItemLike)BuiltInRegistries.f_256975_.m_7745_(first)).output((ItemLike)BuiltInRegistries.f_256975_.m_7745_(second)).build();
    }

    private static class Builder<T extends ProcessingRecipe<?>>
    extends ProcessingRecipeBuilder<T> {
        public Builder(String modid, ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory, String from, String to) {
            super(factory, Create.asResource("runtime_generated/compat/" + modid + "/" + from + "_to_" + to));
        }

        @Override
        public T build() {
            Object t = super.build();
            ProcessingRecipeBuilder.DataGenResult result = new ProcessingRecipeBuilder.DataGenResult(t, Collections.emptyList());
            JSON_FILES.put((Object)result.m_6445_().m_246208_("recipes/"), (Object)result.m_125966_());
            return t;
        }
    }
}

