/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.NarrowWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideWalkwaySideBlock;

public class WideWalkwayCenterBlock
extends AbstractWalkwayBlock {
    public static final BooleanProperty SHAFT = BooleanProperty.m_61465_((String)"shaft");

    public WideWalkwayCenterBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SHAFT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHAFT});
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return WalkwaySlope.HORIZONTAL;
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return (Boolean)state.m_61143_((Property)SHAFT);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (AllBlocks.SHAFT.isIn(heldItem)) {
            if (((Boolean)state.m_61143_((Property)SHAFT)).booleanValue()) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)SHAFT, (Comparable)Boolean.valueOf(true))));
            ((ShaftBlock)AllBlocks.SHAFT.get()).playEncaseSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (((Boolean)state.m_61143_((Property)SHAFT)).booleanValue()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (player != null && !player.m_7500_()) {
                player.m_150109_().m_150079_(AllBlocks.SHAFT.asStack());
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)SHAFT, (Comparable)Boolean.valueOf(false))));
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)pos, 1.0f, level.f_46441_.m_188501_() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        if (remove) {
            return (BlockState)((BlockState)((BlockState)this.getWalkwaySet().getWideSideBlock(level, state, pos).m_61124_(HORIZONTAL_FACING, (Comparable)facing)).m_61124_((Property)WideWalkwaySideBlock.LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)NarrowWalkwayBlock.CAPS_SIDED, (Comparable)((Object)(shaft ? WalkwayCaps.NONE : WalkwayCaps.NO_SHAFT)));
        }
        return (BlockState)state.m_61124_((Property)SHAFT, (Comparable)Boolean.valueOf(shaft));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        return face.m_122434_().m_122479_();
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return EscalatedShapes.WIDE_WALKWAY_CENTER;
    }
}

