/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class EscalatorVoxelShaper {
    private static final int STEP_COUNT = 32;
    protected final List<VoxelShaper> shapes;

    protected EscalatorVoxelShaper(List<VoxelShaper> shapes) {
        this.shapes = shapes;
    }

    public VoxelShape getShape(float visualOffset, Direction facing) {
        int sz = this.shapes.size();
        if (facing == Direction.NORTH || facing == Direction.EAST) {
            visualOffset *= -1.0f;
        }
        int index = Mth.m_14143_((float)((visualOffset % 0.5f + 1.0f) % 0.5f / 0.5f * (float)sz)) % sz;
        return this.shapes.get(index).get(facing);
    }

    public static EscalatorVoxelShaper createEscalatorStepShapes(VoxelShape baseShape, Direction facing, WalkwaySlope slope) {
        return EscalatorVoxelShaper.createEscalatorStepShapes(baseShape, facing, slope, 32);
    }

    public static EscalatorVoxelShaper createEscalatorStepShapes(VoxelShape baseShape, Direction facing, WalkwaySlope slope, int stepCount) {
        if (facing.m_122434_().m_122478_()) {
            throw new IllegalStateException("Cannot initialize escalator step shaper with facing={UP,DOWN}");
        }
        if (slope == WalkwaySlope.HORIZONTAL || slope == WalkwaySlope.TERMINAL) {
            throw new IllegalStateException("Cannot initialize escalator step shaper with slope={HORIZONTAL,TERMINAL}");
        }
        ArrayList<VoxelShaper> shapes = new ArrayList<VoxelShaper>();
        VoxelShape stepShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        Vector3f dirVec = Direction.SOUTH.m_253071_();
        VoxelShape mask = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
        for (int offset = 0; offset < stepCount; ++offset) {
            float visualOffset = 0.5f * (float)offset / (float)stepCount;
            VoxelShape finalShape = baseShape;
            for (int step = -1; step < 2; ++step) {
                float f = (float)step * 0.5f + visualOffset;
                Vector3f horizOffset = new Vector3f((Vector3fc)dirVec).mul(f);
                float vertOffset = f;
                if (slope == WalkwaySlope.TOP) {
                    vertOffset = Math.min(vertOffset, 0.5f);
                }
                if (slope == WalkwaySlope.BOTTOM) {
                    vertOffset = Math.max(vertOffset, 0.5f);
                }
                Vector3f offsetVec = new Vector3f().add((Vector3fc)horizOffset).add(0.0f, vertOffset - 0.03125f, 0.0f);
                VoxelShape copyStep = stepShape.m_83216_((double)offsetVec.x, (double)offsetVec.y, (double)offsetVec.z);
                copyStep = Shapes.m_83113_((VoxelShape)copyStep, (VoxelShape)mask, (BooleanOp)BooleanOp.f_82689_);
                finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)copyStep);
            }
            shapes.add(VoxelShaper.forHorizontal((VoxelShape)finalShape, (Direction)Direction.SOUTH));
        }
        return new EscalatorVoxelShaper(shapes);
    }
}

