/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.mixin;

import com.biomemusic.AdditionalMusic;
import com.biomemusic.BiomeMusic;
import com.biomemusic.config.CommonConfiguration;
import com.biomemusic.environment.MusicEnvironment;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public class MusicPlayMixin {
    @Shadow
    @Final
    private Map<SoundInstance, Integer> f_120230_;
    @Unique
    private static final Map<ResourceLocation, ResourceLocation> oncePlayed = new HashMap<ResourceLocation, ResourceLocation>();

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/sounds/SoundInstance;getSound()Lnet/minecraft/client/resources/sounds/Sound;")})
    private void biomesMusic$onPlay(SoundInstance sound, CallbackInfo ci) {
        if (sound.m_8070_() != SoundSource.MUSIC) {
            return;
        }
        if (sound instanceof AbstractSoundInstance && ((CommonConfiguration)BiomeMusic.config.getCommonConfig()).pitchVariance > 0.0f) {
            ((AbstractSoundInstance)sound).f_119574_ += BiomeMusic.rand.nextFloat(((CommonConfiguration)BiomeMusic.config.getCommonConfig()).pitchVariance * 2.0f) - ((CommonConfiguration)BiomeMusic.config.getCommonConfig()).pitchVariance;
        }
        if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
            BiomeMusic.LOGGER.info("playing: " + sound.m_7904_() + " sound:" + sound.m_5891_().m_119787_() + " environment: " + MusicEnvironment.environment);
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)("playing: " + sound.m_5891_().m_119787_())), true);
            }
        }
        if (sound.m_5891_() == SoundManager.f_120344_ && sound.m_7904_().m_135827_().equals("biomemusic")) {
            Minecraft.m_91087_().m_91397_().f_120180_ = 0;
        }
    }

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/sounds/SoundInstance;getVolume()F")}, cancellable=true)
    private void biomesMusic$onPlaySound(SoundInstance sound, CallbackInfo ci) {
        if (sound.m_5891_() == null || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (!sound.m_7796_() && sound.m_7438_() != SoundInstance.Attenuation.NONE) {
            if (!oncePlayed.containsKey(sound.m_7904_())) {
                oncePlayed.put(sound.m_7904_(), sound.m_7904_());
                return;
            }
            if (AdditionalMusic.stereoIDs.containsKey(sound.m_7904_())) {
                return;
            }
            if (sound.m_7772_() == 0.0 && sound.m_7780_() == 0.0 && sound.m_7778_() == 0.0) {
                return;
            }
            double distance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(new Vec3(sound.m_7772_(), sound.m_7780_(), sound.m_7778_()));
            if (distance > Math.max(1.0, (double)sound.m_7769_()) * (double)sound.m_5891_().m_119798_() + 10.0) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    private void biomesMusic$limitMaxConcurrent(SoundInstance soundInstance, CallbackInfo ci) {
        if (this.f_120230_ == null || soundInstance == null) {
            return;
        }
        int similarcount = 0;
        for (SoundInstance sound : this.f_120230_.keySet()) {
            if (!sound.m_7904_().equals((Object)soundInstance.m_7904_()) || ++similarcount != ((CommonConfiguration)BiomeMusic.config.getCommonConfig()).maxConcurrentSounds) continue;
            ci.cancel();
            break;
        }
    }
}

