/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.faucet;

import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import fr.lucreeper74.createmetallurgy.content.blocks.faucet.FaucetBlock;
import fr.lucreeper74.createmetallurgy.registries.CMDamageTypes;
import fr.lucreeper74.createmetallurgy.registries.CMFluids;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FaucetBlockEntity
extends SmartBlockEntity {
    private static final int MAX_HEIGHT = 5;
    public static final int TRANSFER_RATE = 5;
    private LazyOptional<IFluidHandler> attachedTank;
    private LazyOptional<IFluidHandler> targetTank;
    private int fallingDistance;
    private FluidStack renderFluid = FluidStack.EMPTY;

    public FaucetBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.fallingDistance = compound.m_128451_("fallingDistance");
        this.renderFluid = compound.m_128441_("renderFluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("renderFluid")) : FluidStack.EMPTY;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("fallingDistance", this.fallingDistance);
        if (!this.renderFluid.isEmpty()) {
            compound.m_128365_("renderFluid", (Tag)this.renderFluid.writeToNBT(new CompoundTag()));
        }
    }

    public void tick() {
        super.tick();
        if (((Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.OPEN)).booleanValue()) {
            this.trySpoutput();
        }
    }

    public LazyOptional<IFluidHandler> getTank(BlockPos pos, Direction direction) {
        BlockEntity attachedBE = this.f_58857_.m_7702_(pos);
        if (attachedBE != null) {
            attachedBE.m_6596_();
            LazyOptional fluidHandler = attachedBE.getCapability(ForgeCapabilities.FLUID_HANDLER, direction);
            if (fluidHandler.isPresent()) {
                return fluidHandler;
            }
        }
        return LazyOptional.empty();
    }

    public LazyOptional<IFluidHandler> getAttachedTank() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FaucetBlock.f_52588_);
        if (this.attachedTank == null) {
            this.attachedTank = this.getTank(this.f_58858_.m_121945_(facing.m_122424_()), facing);
        }
        return this.attachedTank;
    }

    public LazyOptional<IFluidHandler> getTargetTank() {
        BlockPos pos = this.f_58858_;
        int fallDist = 0;
        for (int i = 0; i < 5; ++i) {
            pos = pos.m_7495_();
            fallDist = i + 1;
            if (!this.f_58857_.m_8055_(pos).m_60795_()) break;
        }
        this.targetTank = this.getTank(pos, ((Direction)this.m_58900_().m_61143_((Property)FaucetBlock.f_52588_)).m_122424_());
        if (fallDist != this.fallingDistance) {
            this.fallingDistance = fallDist;
            this.invalidateRenderBoundingBox();
        }
        this.sendData();
        return this.targetTank;
    }

    public void trySpoutput() {
        if (!this.renderFluid.isEmpty()) {
            if (this.f_58857_.m_5776_()) {
                this.createFluidParticles(this.renderFluid);
                return;
            }
            Fluid fluid = this.renderFluid.getFluid();
            if (fluid.m_205067_(CMFluids.MOLTEN_MATERIALS) || fluid.m_205067_(FluidTags.f_13132_)) {
                this.hurtEntities();
            }
        }
        if (this.tryFill() <= 0) {
            if (((Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.POWERED)).booleanValue()) {
                this.spillFluid();
            } else {
                BlockState newState = (BlockState)this.m_58900_().m_61122_((Property)FaucetBlock.OPEN);
                this.m_58904_().m_7731_(this.m_58899_(), newState, 3);
                FaucetBlock.playSound(null, this.m_58904_(), this.m_58899_(), (Boolean)newState.m_61143_((Property)FaucetBlock.OPEN));
            }
        }
    }

    private void hurtEntities() {
        List entities = this.m_58904_().m_45933_(null, this.getRenderBoundingBox());
        for (Entity entity : entities) {
            if (entity.m_5825_()) continue;
            entity.m_20254_(15);
            if (!entity.m_6469_(CMDamageTypes.moltenFluid(entity.m_9236_()), 4.0f)) continue;
            entity.m_5496_(SoundEvents.f_11909_, 0.4f, 3.0f);
        }
    }

    protected int tryFill() {
        IFluidHandler inputTank = (IFluidHandler)this.getAttachedTank().orElse((Object)EmptyFluidHandler.INSTANCE);
        IFluidHandler targetTank = (IFluidHandler)this.getTargetTank().orElse((Object)EmptyFluidHandler.INSTANCE);
        FluidStack fluidInTank = inputTank.getFluidInTank(0).copy();
        if (fluidInTank.isEmpty()) {
            return 0;
        }
        fluidInTank.setAmount(5);
        int fill = 0;
        DirectBeltInputBehaviour directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)this.m_58899_().m_6625_(this.fallingDistance), (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (directBeltInputBehaviour == null || !directBeltInputBehaviour.canInsertFromSide(Direction.UP)) {
            return 0;
        }
        for (boolean simulate : Iterate.trueAndFalse) {
            FluidStack drained;
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int n = fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidInTank, action) : targetTank.fill(fluidInTank, action);
            if (fill <= 0) break;
            if (simulate || this.renderFluid.isFluidEqual(drained = inputTank.drain(fill, IFluidHandler.FluidAction.EXECUTE))) continue;
            this.renderFluid = drained;
            this.sendData();
        }
        return fill;
    }

    protected void spillFluid() {
        IFluidHandler inputTank = (IFluidHandler)this.getAttachedTank().orElse((Object)EmptyFluidHandler.INSTANCE);
        FluidStack fluid = inputTank.drain(5, IFluidHandler.FluidAction.EXECUTE);
        if (!this.renderFluid.isFluidEqual(fluid)) {
            this.renderFluid = fluid;
            this.sendData();
        }
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    public int getFallingDistance() {
        return this.fallingDistance;
    }

    public void neighborChanged(BlockPos neighbor) {
        if (this.f_58858_.m_121945_(((Direction)this.m_58900_().m_61143_((Property)FaucetBlock.f_52588_)).m_122424_()).equals((Object)neighbor)) {
            this.attachedTank = null;
        } else if (this.f_58858_.m_7495_().equals((Object)neighbor)) {
            this.targetTank = null;
        }
    }

    private void createFluidParticles(FluidStack fluid) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof FaucetBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)FaucetBlock.f_52588_);
        Vec3 directionVec = Vec3.m_82528_((Vec3i)direction.m_122436_());
        Vec3 outVec = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(directionVec.m_82490_(0.65).m_82546_(directionVec.m_82541_().m_82490_(0.625)));
        Vec3 outMotion = directionVec.m_82490_(0.010416666977107525).m_82520_(0.0, -0.0625, 0.0);
        for (int i = 0; i < 2; ++i) {
            ParticleOptions fluidParticle = FluidFX.getFluidParticle((FluidStack)fluid);
            Vec3 m = VecHelper.offsetRandomly((Vec3)outMotion, (RandomSource)RandomSource.m_216327_(), (float)0.015625f);
            this.f_58857_.m_7107_(fluidParticle, outVec.f_82479_, outVec.f_82480_, outVec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, (double)(-this.getFallingDistance()), 0.0);
    }
}

