/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.TrailDescriptor;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class BambooHopperEntity
extends AirplaneEntity {
    public BambooHopperEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    @Override
    public Item asItem() {
        return Items.BAMBOO_HOPPER.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.emitSmokeParticle(3.4375f, 1.125f, -0.25f, 0.0f, 0.0f, -0.2f);
        this.emitSmokeParticle(-3.4375f, 1.125f, -0.25f, 0.0f, 0.0f, -0.2f);
        float water = (float)this.f_19799_.getDouble((Object)FluidTags.f_13131_);
        if (water > 0.0f) {
            this.emitSplashParticle(3.4375f, water, -0.5f, 0.0f, 0.0f, 0.0f);
            this.emitSplashParticle(-3.4375f, water, -0.5f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void emitSplashParticle(float x, float y, float z, float nx, float ny, float nz) {
        if (!this.isWithinParticleRange() || !this.m_9236_().f_46443_) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        double length = Math.min(100.0, this.getSpeedVector().m_82553_() * 20.0);
        while (length > 1.0) {
            if (!((length -= 1.0) > (double)this.f_19796_.m_188501_())) continue;
            Vector4f p = this.transformPosition(transform, x + (this.f_19796_.m_188501_() - 0.5f), y, z - (this.f_19796_.m_188501_() - 0.0f));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)p.x, (double)p.y, (double)p.z, (double)nx, (double)ny, (double)nz);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)p.x, (double)p.y, (double)p.z, (double)nx, (double)ny, (double)nz);
        }
    }

    @Override
    protected float getGravity() {
        float water = (float)this.m_204036_(FluidTags.f_13131_);
        return water > 0.0f ? 0.04f * water : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return (float)((double)this.enginePower.getSmooth() * this.getSpeedVector().m_82553_());
    }

    @Override
    protected void updateVelocity() {
        super.updateVelocity();
        if (this.f_19798_) {
            this.m_146926_((this.m_146909_() + this.getProperties().get(VehicleStat.GROUND_PITCH)) * 0.9f - this.getProperties().get(VehicleStat.GROUND_PITCH));
        }
    }

    @Override
    public boolean worksUnderWater() {
        return true;
    }

    @Override
    protected float getDismountRotation() {
        return 0.0f;
    }

    @Override
    public double getZoom() {
        return 6.0;
    }

    @Override
    protected SoundEvent getEngineStartSound() {
        return Sounds.ENGINE_START_BAMBOO_HOPPER.get();
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_BAMBOO_HOPPER.get();
    }
}

