/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.predicates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicateRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;

public class AndEntityModelPredicate
implements EntityModelPredicate {
    public static final Serializer<AndEntityModelPredicate> SERIALIZER = new Serializer<AndEntityModelPredicate>(){

        @Override
        public AndEntityModelPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("predicates") || !json.get("predicates").isJsonArray()) {
                throw new JsonParseException("And-predicate must have array property 'predicates'!");
            }
            ArrayList<EntityModelPredicate> predicates = new ArrayList<EntityModelPredicate>();
            JsonArray array = json.getAsJsonArray("predicates");
            for (JsonElement element : array) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Property 'predicates' must only contain objects!");
                }
                EntityModelPredicate predicate = EntityModelPredicateRegistry.deserializeEntityModelPredicate(element.getAsJsonObject());
                predicates.add(predicate);
            }
            return new AndEntityModelPredicate(predicates);
        }

        @Override
        public JsonObject serialize(AndEntityModelPredicate value) {
            JsonObject json = new JsonObject();
            JsonArray predicatesJson = new JsonArray();
            for (EntityModelPredicate predicate : value.predicates) {
                predicatesJson.add((JsonElement)EntityModelPredicateRegistry.serializeEntityModelPredicate(predicate));
            }
            json.add("predicates", (JsonElement)predicatesJson);
            return json;
        }
    };
    private final List<EntityModelPredicate> predicates;

    public AndEntityModelPredicate(List<EntityModelPredicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean test(Entity entity) {
        for (EntityModelPredicate predicate : this.predicates) {
            if (predicate.test(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Serializer<? extends EntityModelPredicate> getSerializer() {
        return SERIALIZER;
    }
}

