/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potacore.data;

import com.teampotato.potacore.Potacore;
import com.teampotato.potacore.util.NBTUtils;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotatoEntityData
extends SavedData {
    private final Map<String, Object> entityData = new ConcurrentHashMap<String, Object>();

    @NotNull
    public static PotatoEntityData get(@NotNull ServerLevel level) {
        return (PotatoEntityData)level.m_8895_().m_164861_(PotatoEntityData::load, PotatoEntityData::new, "potato_entity_data");
    }

    @NotNull
    public static PotatoEntityData load(CompoundTag tag) {
        PotatoEntityData data = new PotatoEntityData();
        data.loadData(tag);
        return data;
    }

    private void loadData(@NotNull CompoundTag tag) {
        this.entityData.clear();
        for (String uuidStr : tag.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                CompoundTag entityTag = tag.m_128469_(uuidStr);
                for (String key : entityTag.m_128431_()) {
                    Object value = NBTUtils.fromTag(entityTag.m_128423_(key));
                    if (value != null) {
                        this.entityData.put(this.createKey(uuid, key), value);
                        continue;
                    }
                    Potacore.LOGGER.error("Unsupported tag type for key '{}' in UUID '{}'", (Object)key, (Object)uuidStr);
                }
            }
            catch (IllegalArgumentException e) {
                Potacore.LOGGER.error("Invalid UUID in saved data: {}", (Object)uuidStr, (Object)e);
            }
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        this.entityData.forEach((compositeKey, value) -> {
            String[] parts = compositeKey.split(":");
            if (parts.length == 2) {
                UUID uuid = UUID.fromString(parts[0]);
                String key = parts[1];
                CompoundTag entityTag = new CompoundTag();
                Tag tag = NBTUtils.toTag(value);
                if (tag != null) {
                    entityTag.m_128365_(key, tag);
                    compoundTag.m_128365_(uuid.toString(), (Tag)entityTag);
                } else {
                    Potacore.LOGGER.error("Unsupported value type for key '{}' in UUID '{}'", (Object)key, (Object)uuid);
                }
            }
        });
        return compoundTag;
    }

    @Contract(pure=true)
    @NotNull
    private String createKey(@NotNull UUID uuid, String key) {
        return String.valueOf(uuid) + ":" + key;
    }

    public void addData(@NotNull UUID entity, @NotNull String key, @NotNull Object value) {
        this.entityData.put(this.createKey(entity, key), value);
        this.m_77762_();
    }

    public void addDataMap(@NotNull UUID entity, @NotNull Map<String, Object> dataMap) {
        dataMap.forEach((key, value) -> this.addData(entity, (String)key, value));
        this.m_77762_();
    }

    public void removeData(@NotNull UUID entity, @NotNull String key) {
        this.entityData.remove(this.createKey(entity, key));
        this.m_77762_();
    }

    public void removeData(@NotNull UUID entity) {
        this.entityData.keySet().removeIf(key -> key.startsWith(entity.toString()));
        this.m_77762_();
    }

    @Nullable
    public Object getData(@NotNull UUID entity, @NotNull String key) {
        return this.entityData.get(this.createKey(entity, key));
    }

    @Nullable
    public <T> T getAs(UUID uuid, String key, @NotNull Class<T> type) {
        Object val = this.getData(uuid, key);
        return (T)(type.isInstance(val) ? val : null);
    }

    public Optional<String> getString(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, String.class));
    }

    public Optional<Integer> getInt(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, Integer.class));
    }

    public Optional<Double> getDouble(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, Double.class));
    }

    public Optional<Float> getFloat(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, Float.class));
    }

    public Optional<Long> getLong(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, Long.class));
    }

    public Optional<Short> getShort(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, Short.class));
    }

    public Optional<Byte> getByte(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, Byte.class));
    }

    public Optional<ListTag> getList(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, ListTag.class));
    }

    public Optional<CompoundTag> getCompound(UUID uuid, String key) {
        return Optional.ofNullable(this.getAs(uuid, key, CompoundTag.class));
    }

    public void clearAll() {
        this.entityData.clear();
        this.m_77762_();
    }
}

