/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.sync.player;

import java.util.Iterator;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.parties.ClientboundPartyPlayerPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.sync.PartySynchronizer;
import xaero.pac.common.server.parties.party.sync.player.PartyPlayerLazyPacketScheduler;

public final class PlayerFullPartySync
extends PartyPlayerLazyPacketScheduler {
    private State currentState;

    public PlayerFullPartySync(PartySynchronizer synchronizer) {
        super(synchronizer);
    }

    @Override
    public void onLazyPacketsDropped() {
        this.currentState = null;
    }

    @Override
    protected boolean shouldWorkNotClogged(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, ServerPlayer player) {
        return this.currentState != null && !this.currentState.done;
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, ServerPlayer player, int limit) {
        int stepsLeft = limit;
        if (this.currentState.memberIterator == null) {
            this.currentState.start();
            this.synchronizer.sendBasePartyPackets(player, this.currentState.party);
            stepsLeft -= 5;
        }
        while (!this.currentState.done && stepsLeft > 0) {
            if (this.currentState.memberIterator.hasNext()) {
                PartyMember memberInfo = this.currentState.memberIterator.next();
                this.synchronizer.syncToClientPlayerInfo(player, ClientboundPartyPlayerPacket.Type.MEMBER, ClientboundPartyPlayerPacket.Action.ADD, memberInfo);
                --stepsLeft;
                continue;
            }
            if (this.currentState.inviteIterator.hasNext()) {
                PartyInvite invite = this.currentState.inviteIterator.next();
                this.synchronizer.syncToClientPlayerInfo(player, ClientboundPartyPlayerPacket.Type.INVITE, ClientboundPartyPlayerPacket.Action.ADD, invite);
                --stepsLeft;
                continue;
            }
            if (this.currentState.allyIterator.hasNext()) {
                PartyAlly ally = this.currentState.allyIterator.next();
                this.synchronizer.sendToClientAllyAdd(player, ally);
                --stepsLeft;
                continue;
            }
            this.currentState.end();
        }
        if (this.currentState.done) {
            this.synchronizer.sendSyncEnd(player);
            this.currentState = null;
        }
    }

    public void startPartySync(ServerPlayer player, ServerParty party) {
        this.currentState = new State(party);
        this.synchronizer.sendSyncStart(player);
    }

    private static class State {
        private final ServerParty party;
        private Iterator<PartyMember> memberIterator;
        private Iterator<PartyInvite> inviteIterator;
        private Iterator<PartyAlly> allyIterator;
        private boolean done;

        private State(ServerParty party) {
            this.party = party;
        }

        private void start() {
            if (this.party == null) {
                this.done = true;
                return;
            }
            this.memberIterator = this.party.getPartyMemberIterator();
            this.inviteIterator = this.party.getPartyInviteIterator();
            this.allyIterator = this.party.getAllyPartiesIterator();
        }

        private void end() {
            this.done = true;
            this.memberIterator = null;
            this.inviteIterator = null;
            this.allyIterator = null;
        }
    }
}

