/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.player.config;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.client.player.config.IPlayerConfigOptionClientStorage;
import xaero.pac.client.player.config.api.IPlayerConfigClientStorageAPI;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;

public class PlayerConfigOptionClientStorage<T extends Comparable<T>>
implements IPlayerConfigOptionClientStorage<T> {
    protected final PlayerConfigOptionSpec<T> option;
    private T value;
    private boolean defaulted;
    private boolean mutable;

    public PlayerConfigOptionClientStorage(PlayerConfigOptionSpec<T> option, T value) {
        if (option == null) {
            throw new IllegalArgumentException();
        }
        this.option = option;
        this.value = value;
        this.defaulted = true;
    }

    public static <T extends Comparable<T>> PlayerConfigOptionClientStorage<T> createCast(PlayerConfigOptionSpec<T> option, Object value) {
        return new PlayerConfigOptionClientStorage<Comparable>(option, (Comparable)value);
    }

    @Override
    @Nonnull
    public PlayerConfigOptionSpec<T> getOption() {
        return this.option;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.option.getId();
    }

    @Override
    @Nonnull
    public String getComment() {
        return this.option.getComment();
    }

    @Override
    @Nonnull
    public String getTranslation() {
        return this.option.getTranslation();
    }

    @Override
    @Nonnull
    public Object[] getTranslationArgs() {
        return this.option.getTranslationArgs();
    }

    @Override
    @Nonnull
    public String getCommentTranslation() {
        return this.option.getCommentTranslation();
    }

    @Override
    @Nonnull
    public Object[] getCommentTranslationArgs() {
        return this.option.getCommentTranslationArgs();
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return this.option.getType();
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public BiPredicate<IPlayerConfigClientStorageAPI, T> getValidator() {
        return this.option.getClientSideValidator();
    }

    @Override
    @Nullable
    public String getTooltipPrefix() {
        return this.option.getTooltipPrefix();
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public void setCastValue(Object value) {
        if (value != null && this.getType() != value.getClass()) {
            throw new IllegalArgumentException();
        }
        this.setValue((Comparable)value);
    }

    @Override
    public void setDefaulted(boolean defaulted) {
        this.defaulted = defaulted;
    }

    @Override
    public boolean isDefaulted() {
        return this.defaulted;
    }

    @Override
    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isDynamic() {
        return this.option.isDynamic();
    }

    public static abstract class Builder<T extends Comparable<T>, B extends Builder<T, B>> {
        protected final B self = this;
        protected PlayerConfigOptionSpec<T> option;
        protected T value;

        protected Builder() {
        }

        public B setDefault() {
            this.setOption(null);
            this.setValue(null);
            return this.self;
        }

        public B setOption(PlayerConfigOptionSpec<T> option) {
            this.option = option;
            return this.self;
        }

        public B setValue(T value) {
            this.value = value;
            return this.self;
        }

        public PlayerConfigOptionClientStorage<T> build() {
            if (this.option == null) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract PlayerConfigOptionClientStorage<T> buildInternally();
    }
}

