/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform.network;

import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.core.SectionPos;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetwork
implements FrameworkNetwork {
    private final SimpleChannel channel;

    public ForgeNetwork(SimpleChannel channel) {
        this.channel = channel;
    }

    @Override
    public void sendToPlayer(Supplier<ServerPlayer> supplier, IMessage<?> message) {
        this.channel.send(PacketDistributor.PLAYER.with(supplier), message);
    }

    @Override
    @Deprecated
    public void sendToTracking(Supplier<Entity> supplier, IMessage<?> message) {
        this.sendToTrackingEntity(supplier, message);
    }

    @Override
    public void sendToTrackingEntity(Supplier<Entity> supplier, IMessage<?> message) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(supplier), message);
    }

    @Override
    public void sendToTrackingBlockEntity(Supplier<BlockEntity> supplier, IMessage<?> message) {
        this.sendToTrackingChunk(() -> {
            BlockEntity entity = (BlockEntity)supplier.get();
            return entity.m_58904_().m_46745_(entity.m_58899_());
        }, message);
    }

    @Override
    public void sendToTrackingLocation(Supplier<LevelLocation> supplier, IMessage<?> message) {
        this.sendToTrackingChunk(() -> {
            LevelLocation location = (LevelLocation)supplier.get();
            Vec3 pos = location.pos();
            int chunkX = SectionPos.m_235865_((double)pos.f_82479_);
            int chunkZ = SectionPos.m_235865_((double)pos.f_82481_);
            return location.level().m_6325_(chunkX, chunkZ);
        }, message);
    }

    @Override
    public void sendToTrackingChunk(Supplier<LevelChunk> supplier, IMessage<?> message) {
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(supplier), message);
    }

    @Override
    public void sendToNearbyPlayers(Supplier<LevelLocation> supplier, IMessage<?> message) {
        this.channel.send(PacketDistributor.NEAR.with(() -> {
            LevelLocation location = (LevelLocation)supplier.get();
            Vec3 pos = location.pos();
            return new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, location.range(), location.level().m_46472_());
        }), message);
    }

    @Override
    public void sendToServer(IMessage<?> message) {
        this.channel.sendToServer(message);
    }

    @Override
    public void sendToAll(IMessage<?> message) {
        this.channel.send(PacketDistributor.ALL.noArg(), message);
    }

    @Override
    public boolean isActive(Connection connection) {
        return this.channel.isRemotePresent(connection);
    }
}

