/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item.hatchet;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.dakotapride.garnished.item.hatchet.HatchetUtils;
import net.dakotapride.garnished.registry.GarnishedEnchantments;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HatchetToolItem
extends DiggerItem
implements Vanishable {
    protected static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).put((Object)Blocks.f_50686_, (Object)Blocks.f_50687_).put((Object)Blocks.f_50688_, (Object)Blocks.f_50689_).put((Object)Blocks.f_50695_, (Object)Blocks.f_50696_).put((Object)Blocks.f_50697_, (Object)Blocks.f_50698_).put((Object)Blocks.f_220836_, (Object)Blocks.f_220837_).put((Object)Blocks.f_220832_, (Object)Blocks.f_220835_).build();

    public HatchetToolItem(Tier tier, float damage, float speed, Item.Properties properties) {
        super(damage, speed, tier, GarnishedTags.MINEABLE_WITH_HATCHET, properties);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44986_) {
            return true;
        }
        if (enchantment == Enchantments.f_44963_) {
            return true;
        }
        if (enchantment == Enchantments.f_44962_) {
            return true;
        }
        if (enchantment == Enchantments.f_44984_) {
            return true;
        }
        if (enchantment == Enchantments.f_44987_) {
            return true;
        }
        if (enchantment == Enchantments.f_44981_) {
            return true;
        }
        if (enchantment == Enchantments.f_44980_) {
            return true;
        }
        if (enchantment == Enchantments.f_44985_) {
            return true;
        }
        if (enchantment == GarnishedEnchantments.SALVAGING.get()) {
            return true;
        }
        if (enchantment == GarnishedEnchantments.RAVAGING.get()) {
            return true;
        }
        if (enchantment == GarnishedEnchantments.STRIKING.get()) {
            return true;
        }
        if (enchantment == GarnishedEnchantments.QUICK_STEP.get()) {
            return true;
        }
        if (enchantment == GarnishedEnchantments.REJUVENATE.get()) {
            return true;
        }
        if (enchantment == GarnishedEnchantments.LEECHING_CURSE.get()) {
            return true;
        }
        if (enchantment == Enchantments.f_44982_) {
            return false;
        }
        if (enchantment == Enchantments.f_44977_) {
            return false;
        }
        if (enchantment == Enchantments.f_44978_) {
            return false;
        }
        if (enchantment == Enchantments.f_44979_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(pContext, ToolActions.AXE_STRIP, false));
        Optional optional1 = optional.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(pContext, ToolActions.AXE_SCRAPE, false));
        Optional optional2 = optional.isPresent() || optional1.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(pContext, ToolActions.AXE_WAX_OFF, false));
        ItemStack itemstack = pContext.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)optional3.get())));
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(pContext.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static BlockState getAxeStrippingState(BlockState originalState) {
        Block block = STRIPPABLES.get(originalState.m_60734_());
        return block != null ? (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)originalState.m_61143_((Property)RotatedPillarBlock.f_55923_))) : null;
    }

    private Optional<BlockState> getStripped(BlockState pUnstrippedState) {
        return Optional.ofNullable(STRIPPABLES.get(pUnstrippedState.m_60734_())).map(block -> (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)pUnstrippedState.m_61143_((Property)RotatedPillarBlock.f_55923_))));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction);
    }

    public float m_8102_(@NotNull ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean m_7579_(ItemStack pStack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        pStack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_8096_(BlockState block) {
        if (block.m_60713_(Blocks.f_50033_)) {
            return true;
        }
        return block.m_204336_(GarnishedTags.MINEABLE_WITH_HATCHET);
    }

    public void dropsUponDeath(LivingEntity user, LivingEntity victim) {
        if (!victim.m_9236_().m_5776_() && victim.m_20194_().m_129900_().m_46207_(GameRules.f_46135_)) {
            EntityType type = victim.m_6095_();
            if (victim.m_20194_() != null) {
                if (HatchetUtils.hasRavaging(user) && HatchetUtils.isAffectedByRavaging((Entity)victim)) {
                    DamageSource source;
                    LootTable lootTable = victim.m_20194_().m_278653_().m_278676_(new ResourceLocation(BuiltInRegistries.f_256780_.m_7981_((Object)type).m_135827_(), "entities/ravaging/" + type.m_147048_()));
                    LootParams.Builder builder = new LootParams.Builder((ServerLevel)user.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)user.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)user);
                    LootContextParam ctxParameters = LootContextParams.f_81457_;
                    if (user instanceof Player) {
                        Player player = (Player)user;
                        source = user.m_269291_().m_269075_(player);
                    } else {
                        source = user.m_269291_().m_269333_(user);
                    }
                    LootParams lootContextParameterSet = builder.m_287286_(ctxParameters, (Object)source).m_287235_(LootContextParamSets.f_81415_);
                    ObjectArrayList list = lootTable.m_287195_(lootContextParameterSet);
                    Objects.requireNonNull(victim);
                    list.forEach(arg_0 -> ((LivingEntity)victim).m_19983_(arg_0));
                } else if (HatchetUtils.hasSalvaging(user) && HatchetUtils.isAffectedBySalvaging((Entity)victim)) {
                    DamageSource source;
                    LootTable lootTable = victim.m_20194_().m_278653_().m_278676_(new ResourceLocation(BuiltInRegistries.f_256780_.m_7981_((Object)type).m_135827_(), "entities/salvaging/" + type.m_147048_()));
                    LootParams.Builder builder = new LootParams.Builder((ServerLevel)user.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)user.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)user);
                    LootContextParam ctxParameters = LootContextParams.f_81457_;
                    if (user instanceof Player) {
                        Player player = (Player)user;
                        source = user.m_269291_().m_269075_(player);
                    } else {
                        source = user.m_269291_().m_269333_(user);
                    }
                    LootParams lootContextParameterSet = builder.m_287286_(ctxParameters, (Object)source).m_287235_(LootContextParamSets.f_81415_);
                    ObjectArrayList list = lootTable.m_287195_(lootContextParameterSet);
                    Objects.requireNonNull(victim);
                    list.forEach(arg_0 -> ((LivingEntity)victim).m_19983_(arg_0));
                }
            }
        }
    }
}

