/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item;

import java.util.List;
import java.util.Random;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.dakotapride.garnished.registry.GarnishedFoodValues;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public interface IGarnishedUtilities {
    public static final int tick = 20;
    public static final int cinder_dur = 1800;
    public static final int cr_cider_dur = 900;
    public static final int bit_cider_dur = 800;
    public static final int cashew_dur = 1000;
    public static final int almond_dur = 500;
    public static final int tangle_dur = 900;
    public static final int cashew_mix_dur = 3600;
    public static final int cognate_dur = 1200;
    public static final int cane_effect_dur = 200;
    public static final int sugar_high_dur = 500;

    default public void addEffectTooltip(List<Component> tooltip, MobEffect effect, int amplifier, float duration) {
        tooltip.add((Component)Component.m_237110_((String)"text.garnished.applies_effect", (Object[])new Object[]{Component.m_237115_((String)effect.m_19481_()), amplifier, this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).m_130940_(effect.m_19483_().m_19497_()));
    }

    default public void addEffectTooltip(List<Component> tooltip, MobEffect effect, float duration) {
        tooltip.add((Component)Component.m_237110_((String)"text.garnished.applies_effect.no_amplifier", (Object[])new Object[]{Component.m_237115_((String)effect.m_19481_()), this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).m_130940_(effect.m_19483_().m_19497_()));
    }

    default public void addEffectTooltipConditionalPositive(List<Component> tooltip, MobEffect effect, float duration) {
        tooltip.add((Component)Component.m_237110_((String)"text.garnished.applies_effect.no_amplifier.conditional.pos", (Object[])new Object[]{Component.m_237115_((String)effect.m_19481_()).m_130940_(ChatFormatting.BLUE), Component.m_237110_((String)"text.garnished.effect.duration", (Object[])new Object[]{this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).m_130940_(effect.m_19483_().m_19497_())}).m_130940_(ChatFormatting.GOLD));
    }

    default public void addEffectTooltipConditionalNegative(List<Component> tooltip, MobEffect effect, float duration) {
        tooltip.add((Component)Component.m_237110_((String)"text.garnished.applies_effect.no_amplifier.conditional.neg", (Object[])new Object[]{Component.m_237115_((String)effect.m_19481_()).m_130940_(ChatFormatting.RED), Component.m_237110_((String)"text.garnished.effect.duration", (Object[])new Object[]{this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).m_130940_(effect.m_19483_().m_19497_())}).m_130940_(ChatFormatting.GOLD));
    }

    default public void addChanceForEffect(List<Component> tooltip, float chance) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"text.garnished.applies_effect.chance", (Object[])new Object[]{chance * 100.0f + "%"}).m_130940_(ChatFormatting.GRAY));
        }
    }

    default public Component formatDuration(MobEffectInstance effect, float duration, float durationFactor) {
        if (effect.m_267577_()) {
            return Component.m_237115_((String)"effect.duration.infinite");
        }
        int i = Mth.m_14143_((float)(duration * durationFactor));
        return Component.m_237113_((String)StringUtil.m_14404_((int)i));
    }

    default public String garnishedText() {
        return "text.garnished.nut.garnished";
    }

    default public String ungarnishedText() {
        return "text.garnished.nut.ungarnished";
    }

    default public ChatFormatting standard() {
        return ChatFormatting.GRAY;
    }

    default public String sweetenedText() {
        return "text.garnished.nut.sweetened";
    }

    default public ChatFormatting sweetened() {
        return ChatFormatting.AQUA;
    }

    default public String honeyedText() {
        return "text.garnished.nut.honeyed";
    }

    default public Style honeyed() {
        return Style.f_131099_.m_178520_(15632655);
    }

    default public String cinderFlourText() {
        return "text.garnished.nut.cinder_flour";
    }

    default public String meltedCinderFlourText() {
        return "text.garnished.nut.cinder_flour.melted";
    }

    default public ChatFormatting cinderFlour() {
        return ChatFormatting.RED;
    }

    default public String chocolateGlazedText() {
        return "text.garnished.nut.chocolate_glazed";
    }

    default public Style chocolateGlazed() {
        return Style.f_131099_.m_178520_(11621438);
    }

    default public MobEffectInstance triggerConditionalEffect(int value, float chance) {
        float floatChance = new Random().nextFloat(0.0f, 1.0f);
        if (value == 0 && GarnishedFoodValues.hasSugarHigh && floatChance < chance) {
            return new MobEffectInstance(MobEffects.f_19605_, 240, 1);
        }
        if (value == 1 && GarnishedFoodValues.hasFreezing && floatChance < chance) {
            return new MobEffectInstance(MobEffects.f_19605_, 240, 1);
        }
        if (value == 2 && GarnishedFoodValues.hasHunger && floatChance < chance) {
            return new MobEffectInstance((MobEffect)GarnishedEffects.THORNS.get(), 480, 1);
        }
        if (value == 3 && GarnishedFoodValues.hasLevitation && floatChance < chance) {
            return new MobEffectInstance(MobEffects.f_19591_, 480, 1);
        }
        if (value == 4) {
            if (GarnishedFoodValues.hasBadOmen && floatChance < chance) {
                return new MobEffectInstance(MobEffects.f_19613_, 720, 1);
            }
            return new MobEffectInstance(MobEffects.f_19606_, 720, 1);
        }
        if (value == 5 && GarnishedFoodValues.isOnFire && floatChance < chance) {
            return new MobEffectInstance(MobEffects.f_19607_, 480, 1);
        }
        if (value == 6) {
            int random = new Random().nextInt(2);
            if (random == 1) {
                return new MobEffectInstance(MobEffects.f_19600_, 900, 2);
            }
            return new MobEffectInstance(MobEffects.f_19597_, 900, 2);
        }
        return new MobEffectInstance(MobEffects.f_19605_, 400, 1, false, false, false);
    }
}

