/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item;

import net.dakotapride.garnished.block.IDesolateSpread;
import net.dakotapride.garnished.registry.GarnishedFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.NotNull;

public class DesolateSpreadItem
extends Item {
    public static final int SPREAD_WIDTH = 3;
    public static final int SPREAD_HEIGHT = 1;
    public static final int COUNT_MULTIPLIER = 3;

    public DesolateSpreadItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (this.applySpread(ctx.m_43722_(), level, pos)) {
            if (!level.f_46443_) {
                // empty if block
            }
            DesolateSpreadItem.getParticles((LevelAccessor)level, pos, 0);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean applySpread(ItemStack stack, Level level, BlockPos pos) {
        IDesolateSpread spreadableBlock;
        BlockState blockstate = level.m_8055_(pos);
        if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_) && blockstate.m_60734_().m_49966_().m_60713_(Blocks.f_50259_)) {
            if (level instanceof ServerLevel) {
                if (this.isSuccessful()) {
                    this.performSpread((ServerLevel)level, level.f_46441_, pos);
                }
                stack.m_41774_(1);
            }
            return true;
        }
        Block block = blockstate.m_60734_();
        if (block instanceof IDesolateSpread && (spreadableBlock = (IDesolateSpread)block).isValidTarget((BlockGetter)level, pos, blockstate, level.f_46443_)) {
            if (level instanceof ServerLevel) {
                if (spreadableBlock.isSuccess(level, level.f_46441_, pos, blockstate)) {
                    spreadableBlock.performSpread((ServerLevel)level, level.f_46441_, pos, blockstate);
                }
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public boolean isSuccessful() {
        return true;
    }

    public void performSpread(ServerLevel level, RandomSource random, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        BlockPos blockpos = pos.m_7494_();
        ChunkGenerator chunkgenerator = level.m_7726_().m_8481_();
        Registry registry = level.m_9598_().m_175515_(Registries.f_256911_);
        if (blockstate.m_60713_(Blocks.f_50259_)) {
            this.place(registry, level, chunkgenerator, random, blockpos);
        }
    }

    private void place(Registry<ConfiguredFeature<?, ?>> registry, ServerLevel level, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        registry.m_203636_(GarnishedFeatures.END_STONE_VEGETATION_SPREAD_CONFIGURED).ifPresent(p_255920_ -> ((ConfiguredFeature)p_255920_.m_203334_()).m_224953_((WorldGenLevel)level, generator, random, pos));
    }

    public static void getParticles(LevelAccessor level, BlockPos pos, int data) {
        block7: {
            double d1;
            BlockState blockstate;
            if (data == 0) {
                data = 15;
            }
            if ((blockstate = level.m_8055_(pos)).m_60795_()) break block7;
            double d0 = 0.5;
            if (blockstate.m_60804_((BlockGetter)level, pos)) {
                pos = pos.m_7494_();
                data *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            }
            Block block = blockstate.m_60734_();
            if (block instanceof IDesolateSpread) {
                IDesolateSpread spreadableBlock = (IDesolateSpread)block;
                level.m_7106_((ParticleOptions)spreadableBlock.getParticle(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                randomsource = level.m_213780_();
                for (int i = 0; i < data; ++i) {
                    double d8;
                    double d7;
                    double d2 = randomsource.m_188583_() * 0.02;
                    double d3 = randomsource.m_188583_() * 0.02;
                    double d4 = randomsource.m_188583_() * 0.02;
                    double d5 = 0.5 - d0;
                    double d6 = (double)pos.m_123341_() + d5 + randomsource.m_188500_() * d0 * 2.0;
                    if (level.m_8055_(new BlockPos((int)d6, (int)(d7 = (double)pos.m_123342_() + randomsource.m_188500_() * d1), (int)(d8 = (double)pos.m_123343_() + d5 + randomsource.m_188500_() * d0 * 2.0)).m_7495_()).m_60795_()) continue;
                    level.m_7106_((ParticleOptions)spreadableBlock.getParticle(), d6, d7, d8, d2, d3, d4);
                }
            } else {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                randomsource = level.m_213780_();
                for (int i = 0; i < data; ++i) {
                    double d8;
                    double d7;
                    double d2 = randomsource.m_188583_() * 0.02;
                    double d3 = randomsource.m_188583_() * 0.02;
                    double d4 = randomsource.m_188583_() * 0.02;
                    double d5 = 0.5 - d0;
                    double d6 = (double)pos.m_123341_() + d5 + randomsource.m_188500_() * d0 * 2.0;
                    if (level.m_8055_(new BlockPos((int)d6, (int)(d7 = (double)pos.m_123342_() + randomsource.m_188500_() * d1), (int)(d8 = (double)pos.m_123343_() + d5 + randomsource.m_188500_() * d0 * 2.0)).m_7495_()).m_60795_()) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d6, d7, d8, d2, d3, d4);
                }
            }
        }
    }
}

