/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.GenerationPiece;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.Tags;

public class DriftwoodFeature
extends Feature<NoneFeatureConfiguration> {
    public DriftwoodFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        boolean standing = rand.m_188501_() < 0.25f;
        BlockState downState = world.m_8055_(pos.m_7495_());
        if (standing && world.m_8055_(pos).m_60734_() == Blocks.f_49990_ && (downState.m_204336_(BlockTags.f_144274_) || downState.m_204336_(Tags.Blocks.SAND))) {
            Direction upDirection = Direction.UP;
            if (this.isDirectionOpen((LevelAccessor)world, pos, upDirection, 3)) {
                for (int i = 0; i < 3; ++i) {
                    this.placeDriftwoodLog((LevelAccessor)world, pos.m_5484_(upDirection, i), upDirection, null);
                    if (!rand.m_188499_()) continue;
                    Direction horizontalDirection = Direction.m_122407_((int)rand.m_188503_(4));
                    if (!world.m_46859_(pos.m_5484_(upDirection, i).m_121945_(horizontalDirection)) || !BlockUtil.isPosNotTouchingBlock((LevelAccessor)world, (BlockPos)pos.m_5484_(upDirection, i).m_121945_(horizontalDirection), (Block)((Block)UABlocks.DRIFTWOOD_LOG.get()), (Direction[])new Direction[]{horizontalDirection.m_122424_()})) continue;
                    this.placeDriftwoodLog((LevelAccessor)world, pos.m_5484_(upDirection, i).m_121945_(horizontalDirection), horizontalDirection, null);
                }
                return true;
            }
            return false;
        }
        Direction direction = Direction.m_122407_((int)rand.m_188503_(4));
        int length = rand.m_188503_(3) + 3;
        if (world.m_204166_(pos).m_203656_(BiomeTags.f_207603_)) {
            pos = pos.m_7495_();
        }
        if (rand.m_188501_() < 0.25f && world.m_204166_(pos).m_203656_(BiomeTags.f_207603_) && this.canFitInOcean((LevelAccessor)world, pos, direction, length) && world.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_49990_ && world.m_46859_(pos.m_7494_()) || !world.m_204166_(pos).m_203656_(BiomeTags.f_207603_) && this.isNearWater((LevelAccessor)world, pos) && downState.m_204336_(BlockTags.f_144274_) || downState.m_204336_(Tags.Blocks.SAND) && this.isDirectionOpen((LevelAccessor)world, pos, direction, length) && this.isGroundForDirectionMostlySuitable((LevelAccessor)world, pos, direction, length)) {
            GenerationPiece driftwood = new GenerationPiece((iworld, part) -> world.m_46859_(part.pos) || world.m_6425_(part.pos).m_205070_(FluidTags.f_13131_));
            for (int i = 0; i < length; ++i) {
                Direction upOrDown;
                this.placeDriftwoodLog((LevelAccessor)world, pos.m_5484_(direction, i), direction, driftwood);
                if (rand.m_188499_()) {
                    this.placeBranch((LevelAccessor)world, pos.m_5484_(direction, i), direction, rand, length >= 5, driftwood);
                }
                if (!rand.m_188499_()) continue;
                Direction direction2 = upOrDown = rand.m_188499_() ? Direction.UP : Direction.DOWN;
                if (!this.isBlockPlaceableAtPos((LevelAccessor)world, pos.m_5484_(direction, i).m_121945_(upOrDown), world.m_204166_(pos.m_5484_(direction, i).m_121945_(upOrDown)).m_203656_(BiomeTags.f_207603_)) || !BlockUtil.isPosNotTouchingBlock((LevelAccessor)world, (BlockPos)pos.m_5484_(direction, i).m_121945_(upOrDown), (Block)((Block)UABlocks.DRIFTWOOD_LOG.get()), (Direction[])new Direction[]{Direction.UP, Direction.DOWN})) continue;
                this.placeDriftwoodLog((LevelAccessor)world, pos.m_5484_(direction, i).m_121945_(upOrDown), upOrDown, driftwood);
            }
            driftwood.tryToPlace((LevelAccessor)world);
            return true;
        }
        return false;
    }

    private boolean isDirectionOpen(LevelAccessor world, BlockPos pos, Direction direction, int length) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        if (direction == Direction.UP) {
            return world.m_6425_((BlockPos)mutable).m_205070_(FluidTags.f_13131_) && world.m_46859_(mutable.m_7494_()) && world.m_46859_(mutable.m_6630_(2));
        }
        for (int i = 0; i < length; ++i) {
            mutable.m_5484_(direction, i);
            if (world.m_46859_((BlockPos)mutable) || world.m_6425_((BlockPos)mutable).m_76152_().m_205067_(FluidTags.f_13131_)) continue;
            return false;
        }
        return true;
    }

    private boolean canFitInOcean(LevelAccessor world, BlockPos pos, Direction direction, int length) {
        for (int i = 0; i < length; ++i) {
            if (world.m_8055_(pos.m_5484_(direction, i)).m_60713_(Blocks.f_49990_)) continue;
            return false;
        }
        return true;
    }

    private boolean isGroundForDirectionMostlySuitable(LevelAccessor world, BlockPos pos, Direction direction, int length) {
        int foundGaps = 0;
        for (int i = 0; i < length; ++i) {
            if (world.m_8055_(pos.m_7495_().m_5484_(direction, i)).m_204336_(BlockTags.f_144274_) || world.m_8055_(pos.m_7495_().m_5484_(direction, i)).m_204336_(BlockTags.f_13029_)) continue;
            if (world.m_204166_(pos.m_7495_().m_5484_(direction, i)).m_203656_(BiomeTags.f_207603_)) {
                ++foundGaps;
                continue;
            }
            if (world.m_8055_(pos.m_7495_().m_5484_(direction, i)).m_60734_() == Blocks.f_49990_) continue;
            ++foundGaps;
        }
        return (double)foundGaps < Math.ceil(length / 2);
    }

    private boolean isNearWater(LevelAccessor world, BlockPos pos) {
        Holder biome = world.m_204166_(pos);
        int foundWaterSpots = 0;
        if (biome.m_203656_(BiomeTags.f_207605_)) {
            for (int y = pos.m_123342_() - 2; y < pos.m_123342_(); ++y) {
                for (int x = pos.m_123341_() - 3; x < pos.m_123341_() + 3; ++x) {
                    for (int z = pos.m_123343_() - 3; z < pos.m_123343_() + 3; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.m_46861_(currentPos) || !world.m_8055_(currentPos).m_60713_(Blocks.f_49990_)) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        } else {
            for (int y = pos.m_123342_() - 1; y < pos.m_123342_(); ++y) {
                for (int x = pos.m_123341_() - 2; x < pos.m_123341_() + 2; ++x) {
                    for (int z = pos.m_123343_() - 2; z < pos.m_123343_() + 2; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.m_46861_(currentPos) || !world.m_8055_(currentPos).m_60713_(Blocks.f_49990_)) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        }
        return foundWaterSpots >= 3;
    }

    private void placeDriftwoodLog(LevelAccessor world, BlockPos pos, Direction direction, @Nullable GenerationPiece driftwood) {
        if (driftwood != null) {
            driftwood.addBlockPiece((BlockState)((Block)UABlocks.DRIFTWOOD_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), pos);
        } else {
            world.m_7731_(pos, (BlockState)((Block)UABlocks.DRIFTWOOD_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 2);
        }
    }

    private void placeBranch(LevelAccessor world, BlockPos startPos, Direction direction, RandomSource rand, boolean isLarge, GenerationPiece driftwood) {
        int size = isLarge ? rand.m_188503_(2) + 1 : 1;
        Direction branchDirection = rand.m_188499_() ? direction.m_122427_() : direction.m_122428_();
        for (int i = 1; i < size + 1; ++i) {
            Block[] sideBlocks = new Block[]{world.m_8055_(startPos.m_5484_(branchDirection, i).m_121945_(branchDirection.m_122427_())).m_60734_(), world.m_8055_(startPos.m_5484_(branchDirection, i).m_121945_(branchDirection.m_122428_())).m_60734_()};
            if (!this.isBlockPlaceableAtPos(world, startPos.m_5484_(branchDirection, i), world.m_204166_(startPos.m_5484_(branchDirection, i)).m_203656_(BiomeTags.f_207603_)) || sideBlocks[0] == UABlocks.DRIFTWOOD_LOG.get() || sideBlocks[1] == UABlocks.DRIFTWOOD_LOG.get()) break;
            this.placeDriftwoodLog(world, startPos.m_5484_(branchDirection, i), branchDirection, driftwood);
        }
    }

    private boolean isBlockPlaceableAtPos(LevelAccessor world, BlockPos pos, boolean inOcean) {
        Block block = world.m_8055_(pos).m_60734_();
        return inOcean ? world.m_46859_(pos) || block == Blocks.f_49990_ : world.m_46859_(pos);
    }
}

