/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.layer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.client.module.UsesForCursesModule;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class ArmorStandFakePlayerLayer<M extends EntityModel<ArmorStand>>
extends RenderLayer<ArmorStand, M> {
    private final PlayerModel<?> playerModel;
    private final PlayerModel<?> playerModelSlim;

    public ArmorStandFakePlayerLayer(RenderLayerParent<ArmorStand, M> parent, EntityModelSet models) {
        super(parent);
        this.playerModel = new PlayerModel(models.m_171103_(ModelLayers.f_171162_), false);
        this.playerModelSlim = new PlayerModel(models.m_171103_(ModelLayers.f_171166_), true);
    }

    public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int light, @NotNull ArmorStand armor, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        CompoundTag skullOwner;
        GameProfile profile;
        RenderType rendertype;
        if (!UsesForCursesModule.staticEnabled || !UsesForCursesModule.bindArmorStandsWithPlayerHeads) {
            return;
        }
        ItemStack head = armor.m_6844_(EquipmentSlot.HEAD);
        if (head.m_150930_(Items.f_42680_) && EnchantmentHelper.m_44920_((ItemStack)head) && (rendertype = SkullBlockRenderer.m_112523_((SkullBlock.Type)SkullBlock.Types.PLAYER, (GameProfile)(profile = (skullOwner = ItemNBTHelper.getCompound((ItemStack)head, (String)"SkullOwner", (boolean)true)) != null ? NbtUtils.m_129228_((CompoundTag)skullOwner) : null))) != null) {
            MinecraftProfileTexture profileTexture;
            boolean slim = false;
            if (profile != null && (profileTexture = (MinecraftProfileTexture)Minecraft.m_91087_().m_91109_().m_118815_(profile).get(MinecraftProfileTexture.Type.SKIN)) != null) {
                String modelMeta = profileTexture.getMetadata("model");
                slim = "slim".equals(modelMeta);
            }
            pose.m_85836_();
            if (armor.m_6162_()) {
                s = 1.0f;
                pose.m_252880_(0.0f, 0.0f, 0.0f);
                pose.m_85841_(s, s, s);
            } else {
                s = 2.0f;
                pose.m_252880_(0.0f, -1.5f, 0.0f);
                pose.m_85841_(s, s, s);
            }
            PlayerModel<?> model = slim ? this.playerModelSlim : this.playerModel;
            model.f_102808_.f_104207_ = false;
            model.f_102809_.f_104207_ = false;
            this.rotateModel(model.f_102812_, armor.m_31688_());
            this.rotateModel(model.f_102811_, armor.m_31689_());
            this.rotateModel(model.f_103374_, armor.m_31688_());
            this.rotateModel(model.f_103375_, armor.m_31689_());
            this.rotateModel(model.f_102814_, armor.m_31691_());
            this.rotateModel(model.f_102813_, armor.m_31694_());
            this.rotateModel(model.f_103376_, armor.m_31691_());
            this.rotateModel(model.f_103377_, armor.m_31694_());
            model.m_7695_(pose, buffer.m_6299_(rendertype), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.m_85849_();
        }
    }

    private void rotateModel(ModelPart part, Rotations rot) {
        part.m_171327_((float)Math.PI / 180 * rot.m_123156_(), (float)Math.PI / 180 * rot.m_123157_(), (float)Math.PI / 180 * rot.m_123158_());
    }
}

