/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.create_cuisine.interaction_points;

import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.content.logistics.box.PackageItem;
import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.item.PlateItem;
import dev.xkmc.cuisinedelight.content.item.SpatulaItem;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class CuisineSkilletArmInteractionPoint
extends ArmInteractionPoint {
    public CuisineSkilletArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.m_82514_((Vec3i)this.pos, (double)0.125);
    }

    public int getSlotCount() {
        return 1;
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.m_7702_(this.pos);
        if (blockEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)blockEntity;
            ItemStack input = stack.m_41777_();
            if (input.m_41720_() instanceof SpatulaItem) {
                if (be.cookingData.contents.isEmpty()) {
                    return stack;
                }
                if (!this.level.m_5776_() && !simulate) {
                    be.stir(this.level.m_46467_(), 0);
                    this.level.m_6263_(null, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get(), SoundSource.BLOCKS, 1.0f, this.level.f_46441_.m_188501_() * 0.2f + 0.9f);
                    return stack.m_41777_();
                }
                input.m_41774_(1);
                return input;
            }
            if (input.m_41720_() instanceof PlateItem) {
                if (!be.cookingData.contents.isEmpty()) {
                    input.m_41774_(1);
                    if (simulate) {
                        return input;
                    }
                    CookingData data = be.cookingData;
                    data.stir(this.level.m_46467_(), 0);
                    CookedFoodData food = new CookedFoodData(data);
                    ItemStack foodStack = BaseCuisineRecipe.findBestMatch((Level)this.level, (CookedFoodData)food);
                    be.cookingData = new CookingData();
                    be.sync();
                    ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.level), (Vec3)Vec3.m_82512_((Vec3i)this.pos), (int)(food.score * food.size / 100));
                    return foodStack;
                }
                return stack;
            }
            if (input.m_41720_() instanceof PackageItem) {
                if (!simulate) {
                    ItemStackHandler contents = PackageItem.getContents((ItemStack)input);
                    for (int i = 0; i < contents.getSlots(); ++i) {
                        ItemStack itemstack = contents.getStackInSlot(i);
                        int size = itemstack.m_41613_();
                        for (int j = 0; j < size; ++j) {
                            this.tryCook(itemstack, false, be);
                        }
                        if (itemstack.m_41619_()) continue;
                        ItemEntity itemEntity = new ItemEntity(this.level, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), itemstack);
                        this.level.m_7967_((Entity)itemEntity);
                    }
                }
                return ItemStack.f_41583_;
            }
            return this.tryCook(input, simulate, be);
        }
        return stack;
    }

    public ItemStack tryCook(ItemStack stack, boolean simulate, CuisineSkilletBlockEntity be) {
        IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(stack);
        if (config != null) {
            if (!be.canCook()) {
                return stack;
            }
            if (be.cookingData.contents.size() >= (Integer)CDConfig.COMMON.maxIngredient.get()) {
                return stack;
            }
            int count = 1 + be.baseItem.getEnchantmentLevel(Enchantments.f_44984_);
            if (be.slowCook()) {
                be.cookingData.setSpeed(0.5f);
            }
            ItemStack add = stack.m_41620_(count);
            if (!simulate) {
                ItemStack remain = add.getCraftingRemainingItem();
                remain.m_41764_(add.m_41613_());
                be.cookingData.addItem(add, this.level.m_46467_());
                be.sync();
                this.level.m_6263_(null, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 1.0f, this.level.f_46441_.m_188501_() * 0.2f + 0.9f);
                return remain;
            }
            return stack;
        }
        return stack;
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public static class Type
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            CuisineSkilletBlockEntity be;
            BlockEntity blockEntity = level.m_7702_(pos);
            return blockEntity instanceof CuisineSkilletBlockEntity && (be = (CuisineSkilletBlockEntity)blockEntity).canCook() && be.cookingData.contents.size() < (Integer)CDConfig.COMMON.maxIngredient.get();
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CuisineSkilletArmInteractionPoint(this, level, pos, state);
        }
    }
}

