/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;
import traben.entity_model_features.models.animation.math.variables.VariableRegistry;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.IEMFUnmodifiedLayerRootGetter;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;
import traben.tconfig.TConfig;
import traben.tconfig.gui.TConfigScreenList;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryBoolean;
import traben.tconfig.gui.entries.TConfigEntryCategory;
import traben.tconfig.gui.entries.TConfigEntryCustomButton;
import traben.tconfig.gui.entries.TConfigEntryEnumButton;
import traben.tconfig.gui.entries.TConfigEntryEnumSlider;
import traben.tconfig.gui.entries.TConfigEntryInt;
import traben.tconfig.gui.entries.TConfigEntryText;

public class EMFConfig
extends TConfig {
    public boolean logModelCreationData = false;
    public boolean debugOnRightClick = false;
    public RenderModeChoice renderModeChoice = RenderModeChoice.NORMAL;
    public VanillaModelRenderMode vanillaModelHologramRenderMode_2 = VanillaModelRenderMode.OFF;
    public ModelPrintMode modelExportMode = ModelPrintMode.NONE;
    public ETFConfig.UpdateFrequency modelUpdateFrequency = ETFConfig.UpdateFrequency.Average;
    public ETFConfig.String2EnumNullMap<RenderModeChoice> entityRenderModeOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<VanillaModelRenderMode> entityVanillaHologramOverrides = new ETFConfig.String2EnumNullMap();
    public ObjectOpenHashSet<String> modelsNamesDisabled = new ObjectOpenHashSet();
    public boolean allowEBEModConfigModify = true;
    public int animationLODDistance = 20;
    public boolean retainDetailOnLowFps = true;
    public boolean retainDetailOnLargerMobs = true;
    public boolean animationFrameSkipDuringIrisShadowPass = true;
    public boolean preventFirstPersonHandAnimating = false;
    public boolean onlyClientPlayerModel = false;
    public boolean doubleChestAnimFix = true;
    @Deprecated(since="2.4.1", forRemoval=true)
    public boolean enforceOptifineVariationRequiresDefaultModel = false;
    public boolean enforceOptifineVariationRequiresDefaultModel_v2 = false;
    @Deprecated(since="2.4.1", forRemoval=true)
    public boolean resetPlayerModelEachRender = true;
    public boolean resetPlayerModelEachRender_v2 = true;
    public boolean onlyDebugRenderOnHover = false;
    public boolean enforceOptifineSubFoldersVariantOnly = true;
    public boolean enforceOptiFineAnimSyntaxLimits = true;
    public boolean allowOptifineFallbackProperties = true;
    public boolean enforceOptiFineFloorUVs = true;
    public boolean showReloadErrorToast = true;

    public RenderModeChoice getRenderModeFor(EMFEntity entity) {
        String typeString = EMFConfig.getTypeString(entity);
        if (typeString == null) {
            return this.renderModeChoice;
        }
        return Objects.requireNonNullElseGet((RenderModeChoice)this.entityRenderModeOverrides.getNullable(typeString), () -> this.renderModeChoice);
    }

    public VanillaModelRenderMode getVanillaHologramModeFor(EMFEntity entity) {
        String typeString = EMFConfig.getTypeString(entity);
        if (typeString == null) {
            return this.vanillaModelHologramRenderMode_2;
        }
        return Objects.requireNonNullElseGet((VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(typeString), () -> this.vanillaModelHologramRenderMode_2);
    }

    @Nullable
    private static String getTypeString(EMFEntity entity) {
        if (entity instanceof BlockEntity) {
            BlockEntity block = (BlockEntity)entity;
            return ETFApi.getBlockEntityTypeToTranslationKey((BlockEntityType)block.m_58903_());
        }
        if (entity instanceof Entity) {
            Entity realBoy = (Entity)entity;
            return realBoy.m_6095_().m_20675_();
        }
        return null;
    }

    public boolean isModelDisabled(String modelName) {
        return this.modelsNamesDisabled.contains((Object)modelName);
    }

    public TConfigEntryCategory getGUIOptions() {
        return new TConfigEntryCategory.Empty().add(new TConfigEntry[]{new TConfigEntryCategory("config.entity_features.models_main").add(new TConfigEntry[]{new TConfigEntryCategory("entity_model_features.config.options", "entity_model_features.config.options.tooltip").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.ebe_config_modify", "entity_model_features.config.ebe_config_modify.tooltip", () -> this.allowEBEModConfigModify, value -> {
            this.allowEBEModConfigModify = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.double_chest_fix", "entity_model_features.config.double_chest_fix.tooltip", () -> this.doubleChestAnimFix, value -> {
            this.doubleChestAnimFix = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.player_settings").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.prevent_hand", "entity_model_features.config.prevent_hand.tooltip", () -> this.preventFirstPersonHandAnimating, value -> {
            this.preventFirstPersonHandAnimating = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.only_client", "entity_model_features.config.only_client.tooltip", () -> this.onlyClientPlayerModel, value -> {
            this.onlyClientPlayerModel = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.reset_player", "entity_model_features.config.reset_player.tooltip", () -> this.resetPlayerModelEachRender_v2, value -> {
            this.resetPlayerModelEachRender_v2 = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.performance").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.update", "entity_model_features.config.update.tooltip", () -> this.modelUpdateFrequency, value -> {
            this.modelUpdateFrequency = value;
        }, (Enum)ETFConfig.UpdateFrequency.Average), new TConfigEntryInt("entity_model_features.config.lod", "entity_model_features.config.lod.tooltip", () -> this.animationLODDistance, value -> {
            this.animationLODDistance = value;
        }, 20, 0, 65, true, true), new TConfigEntryBoolean("entity_model_features.config.low_fps_lod", "entity_model_features.config.low_fps_lod.tooltip", () -> this.retainDetailOnLowFps, value -> {
            this.retainDetailOnLowFps = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.large_mob_lod", "entity_model_features.config.large_mob_lod.tooltip", () -> this.retainDetailOnLargerMobs, value -> {
            this.retainDetailOnLargerMobs = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.iris_shadow_skip", "entity_model_features.config.iris_shadow_skip.tooltip", () -> this.animationFrameSkipDuringIrisShadowPass, value -> {
            this.animationFrameSkipDuringIrisShadowPass = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.tools", "entity_model_features.config.tools.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> this.vanillaModelHologramRenderMode_2, value -> {
            this.vanillaModelHologramRenderMode_2 = value;
        }, (Enum)VanillaModelRenderMode.OFF), new TConfigEntryEnumSlider("entity_model_features.config.print_mode", "entity_model_features.config.print_mode.tooltip", () -> this.modelExportMode, value -> {
            this.modelExportMode = value;
        }, (Enum)ModelPrintMode.NONE)}), new TConfigEntryCategory("entity_model_features.config.debug", "entity_model_features.config.debug.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> this.renderModeChoice, value -> {
            this.renderModeChoice = value;
        }, (Enum)RenderModeChoice.NORMAL), new TConfigEntryBoolean("entity_model_features.config.debug_hover", "entity_model_features.config.debug_hover.tooltip", () -> this.onlyDebugRenderOnHover, value -> {
            this.onlyDebugRenderOnHover = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.log_models", "entity_model_features.config.log_models.tooltip", () -> this.logModelCreationData, value -> {
            this.logModelCreationData = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.debug_right_click", "entity_model_features.config.debug_right_click.tooltip", () -> this.debugOnRightClick, value -> {
            this.debugOnRightClick = value;
        }, false), new TConfigEntryCustomButton("entity_model_features.config.load_warn.title", "entity_model_features.config.load_warn.tooltip", button -> EMFConfig.reprintLoadingErrors(false)), new TConfigEntryCustomButton("entity_model_features.config.load_warn.title2", "entity_model_features.config.load_warn.tooltip", button -> EMFConfig.reprintLoadingErrors(true)), new TConfigEntryBoolean("entity_model_features.config.show_reload_error_toast", "entity_model_features.config.show_reload_error_toast.tooltip", () -> this.showReloadErrorToast, value -> {
            this.showReloadErrorToast = value;
        }, true)}), this.getModelSettings(), this.getMathInfo()}), this.getEntitySettings(), new TConfigEntryCategory("config.entity_features.optifine_settings", "config.entity_texture_features.optifine.desc").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.variation_base", "entity_model_features.config.variation_base.tooltip", () -> this.enforceOptifineVariationRequiresDefaultModel_v2, value -> {
            this.enforceOptifineVariationRequiresDefaultModel_v2 = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.optifine_subfolders", "entity_model_features.config.optifine_subfolders.tooltip", () -> this.enforceOptifineSubFoldersVariantOnly, value -> {
            this.enforceOptifineSubFoldersVariantOnly = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.optifine_syntax", "entity_model_features.config.optifine_syntax.tooltip", () -> this.enforceOptiFineAnimSyntaxLimits, value -> {
            this.enforceOptiFineAnimSyntaxLimits = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.optifine_fallback_properties", "entity_model_features.config.optifine_fallback_properties.tooltip", () -> this.allowOptifineFallbackProperties, value -> {
            this.allowOptifineFallbackProperties = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.optifine_floor", "entity_model_features.config.optifine_floor.tooltip", () -> this.enforceOptiFineFloorUVs, value -> {
            this.enforceOptiFineFloorUVs = value;
        }, true)})});
    }

    private static void reprintLoadingErrors(boolean stacktrace) {
        EMFUtils.logError("~~//BEGIN: EMF MASS PRINT OF LOADING ERRORS\\\\~~\nNot all errors here will be helpful as they may be missing surrounding log context.\nThis is best used to know what you might need to be searching for in your log\nor to give the dev debugging info.");
        int i = 1;
        for (Exception loadingException : EMFManager.getInstance().loadingExceptions) {
            System.out.println("----------//Exception #" + i + "\\\\---------- \n" + loadingException.getMessage());
            if (stacktrace) {
                loadingException.printStackTrace();
            }
            ++i;
        }
        EMFUtils.logError("~~\\\\END: EMF MASS PRINT OF LOADING ERRORS//~~");
    }

    private TConfigEntryCategory getMathInfo() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.math");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.math.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        TConfigEntryCategory variables = new TConfigEntryCategory("entity_model_features.config.variables");
        category.add((TConfigEntry)variables);
        variables.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.variables.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        for (UniqueVariableFactory uniqueVariableFactory : VariableRegistry.getInstance().getUniqueVariableFactories()) {
            TConfigEntryCategory unique = new TConfigEntryCategory(uniqueVariableFactory.getTitleTranslationKey()).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)uniqueVariableFactory.getExplanationTranslationKey(), (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        }
        VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().get(key);
            TConfigEntryCategory unique = new TConfigEntryCategory(key).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        });
        TConfigEntryCategory methods = new TConfigEntryCategory("entity_model_features.config.functions");
        category.add((TConfigEntry)methods);
        methods.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.functions.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        MethodRegistry.getInstance().getMethodExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = MethodRegistry.getInstance().getMethodExplanationTranslationKeys().get(key);
            TConfigEntryCategory method = new TConfigEntryCategory(key + "()").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            methods.add((TConfigEntry)method);
        });
        return category;
    }

    private TConfigEntryCategory getModelSettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.models");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models_text", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        EMFManager.getInstance().cache_LayersByModelName.put((Object)new EMFModel_ID("wolf_collar"), (Object)ModelLayers.f_171221_);
        EMFManager.getInstance().cache_LayersByModelName.keySet().stream().sorted().forEach(mapData -> {
            LayerDefinition vanilla;
            ModelLayerLocation layer = (ModelLayerLocation)EMFManager.getInstance().cache_LayersByModelName.get(mapData);
            if (layer != null && (vanilla = (LayerDefinition)Minecraft.m_91087_().m_167973_().f_171099_.get(layer)) != null) {
                String namespace = "minecraft".equals(mapData.getNamespace()) ? "" : mapData.getNamespace() + ":";
                String fileName = namespace + mapData.getfileName();
                TConfigEntryCategory model = new TConfigEntryCategory(fileName + ".jem");
                model.setAlign(TConfigScreenList.Align.RIGHT);
                model.setWidgetBackgroundToFullWidth();
                model.setRenderFeature((TConfigScreenList.Renderable)new ModelRootRenderer(layer));
                category.add((TConfigEntry)model);
                StringBuilder fallbacks = new StringBuilder();
                mapData.forEachFallback(fallBackData -> fallbacks.append(fallBackData.getfileName()).append(".jem\n"));
                model.add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.models.enabled", "entity_model_features.config.models.enabled.tooltip", () -> !this.modelsNamesDisabled.contains((Object)fileName), value -> {
                    if (value.booleanValue()) {
                        this.modelsNamesDisabled.remove((Object)fileName);
                    } else {
                        this.modelsNamesDisabled.add((Object)fileName);
                    }
                }, true), new TConfigEntryCategory("entity_model_features.config.models.part_names").addAll(this.getmappings(mapData.getMapId())), this.getExport((EMFModel_ID)mapData, layer), new TConfigEntryCategory("entity_model_features.config.models.file_names").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)("<Folders>\nassets/" + mapData.getNamespace() + "/emf/cem/\nassets/" + mapData.getNamespace() + "/optifine/cem/\n\n<possible model names>\n<checked from top down>\n" + mapData.getfileName() + ".jem\n" + fallbacks), (int)600, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.CENTER))}).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.explain", (int)100, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            }
        });
        return category;
    }

    @NotNull
    private TConfigEntry getExport(EMFModel_ID key, ModelLayerLocation layer) {
        TConfigEntryText.TwoLines export;
        try {
            Objects.requireNonNull(key.getMapId());
            export = new TConfigEntryCustomButton("entity_model_features.config.models.export", "entity_model_features.config.models.export.tooltip", button -> {
                ModelPrintMode old = this.modelExportMode;
                this.modelExportMode = ModelPrintMode.ALL_LOG_AND_JEM;
                try {
                    EMFModelMappings.getMapOf(key, Objects.requireNonNullElseGet(((IEMFUnmodifiedLayerRootGetter)Minecraft.m_91087_().m_167973_()).emf$getUnmodifiedRoots().get(layer), () -> (LayerDefinition)Minecraft.m_91087_().m_167973_().f_171099_.get(layer)).m_171564_(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.modelExportMode = old;
                button.f_93623_ = false;
                button.m_93666_((Component)Component.m_237115_((String)"entity_model_features.config.models.export.success"));
            });
        }
        catch (Exception e) {
            export = new TConfigEntryText.TwoLines("entity_model_features.config.models.export.fail", e.getMessage());
        }
        return export;
    }

    private Collection<TConfigEntry> getmappings(String mapKey) {
        Map<String, String> map;
        ArrayList<TConfigEntry> list = new ArrayList<TConfigEntry>();
        if (EMFModelMappings.OPTIFINE_MODEL_MAP_CACHE.containsKey(mapKey)) {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.optifine_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFModelMappings.OPTIFINE_MODEL_MAP_CACHE.get(mapKey);
        } else {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.unknown_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFModelMappings.UNKNOWN_MODEL_MAP_CACHE.get(mapKey);
        }
        if (map == null) {
            return List.of();
        }
        for (String entry : map.keySet()) {
            list.add((TConfigEntry)new TConfigEntryText(entry));
        }
        return list;
    }

    private TConfigEntryCategory getEntitySettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.per_entity_settings");
        try {
            BuiltInRegistries.f_256780_.forEach(entityType -> {
                String translationKey = entityType.m_20675_();
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
            BlockEntityRenderers.f_173587_.keySet().forEach(entityType -> {
                String translationKey = ETFApi.getBlockEntityTypeToTranslationKey((BlockEntityType)entityType);
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return category;
    }

    private void addEntityConfigs(TConfigEntryCategory entityCategory, String translationKey) {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.models_main");
        entityCategory.add((TConfigEntry)category);
        category.add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> (RenderModeChoice)this.entityRenderModeOverrides.getNullable(translationKey), layer -> this.entityRenderModeOverrides.putNullable(translationKey, (Enum)layer), null, RenderModeChoice.class), new TConfigEntryEnumButton("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> (VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(translationKey), layer -> this.entityVanillaHologramOverrides.putNullable(translationKey, (Enum)layer), null, VanillaModelRenderMode.class)});
    }

    public ResourceLocation getModIcon() {
        return EMFUtils.res("entity_model_features", "textures/gui/icon.png");
    }

    public static enum RenderModeChoice {
        NORMAL("entity_model_features.config.render.normal"),
        GREEN("entity_model_features.config.render.green"),
        LINES_AND_TEXTURE("entity_model_features.config.render.lines_texture"),
        LINES_AND_TEXTURE_FLASH("entity_model_features.config.render.lines_texture_flash"),
        LINES("entity_model_features.config.render.lines"),
        NONE("entity_model_features.config.render.none");

        private final String text;

        private RenderModeChoice(String text) {
            this.text = text;
        }

        public String toString() {
            return Component.m_237115_((String)this.text).getString();
        }
    }

    public static enum VanillaModelRenderMode {
        OFF("options.off"),
        NORMAL("entity_model_features.config.vanilla_render.normal"),
        OFFSET("entity_model_features.config.vanilla_render.offset");

        private final String text;

        private VanillaModelRenderMode(String text) {
            this.text = text;
        }

        public String toString() {
            return Component.m_237115_((String)this.text).getString();
        }
    }

    public static enum ModelPrintMode {
        NONE("options.off"),
        LOG_ONLY("entity_model_features.config.print_mode.log"),
        LOG_AND_JEM("entity_model_features.config.print_mode.log_jem"),
        ALL_LOG_ONLY("entity_model_features.config.print_mode.all_log"),
        ALL_LOG_AND_JEM("entity_model_features.config.print_mode.all_log_jem");

        private final String text;

        private ModelPrintMode(String text) {
            this.text = text;
        }

        public boolean doesJems() {
            return this == LOG_AND_JEM || this == ALL_LOG_AND_JEM;
        }

        public boolean doesAll() {
            return this == ALL_LOG_ONLY || this == ALL_LOG_AND_JEM;
        }

        public boolean doesLog() {
            return this != NONE;
        }

        public String toString() {
            return Component.m_237115_((String)this.text).getString();
        }
    }

    private static class ModelRootRenderer
    implements TConfigScreenList.Renderable {
        private final ModelLayerLocation layer;
        private ModelPart root = null;
        private boolean asserted = false;

        ModelRootRenderer(ModelLayerLocation layer) {
            this.layer = layer;
        }

        private boolean canRender() {
            if (!this.asserted && this.root == null) {
                this.asserted = true;
                try {
                    this.root = ((LayerDefinition)Minecraft.m_91087_().m_167973_().f_171099_.get(this.layer)).m_171564_();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.root != null;
        }

        public void render(GuiGraphics context, int mouseX, int mouseY) {
            if (this.canRender()) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen == null) {
                    return;
                }
                int y = (int)((double)screen.f_96544_ * 0.75);
                int x = (int)((double)screen.f_96543_ * 0.33);
                float g = (float)(-Math.atan(((float)(-mouseY) + (float)screen.f_96544_ / 2.0f) / 40.0f));
                float g2 = (float)(-Math.atan(((float)(-mouseX) + (float)screen.f_96543_ / 3.0f) / 400.0f));
                Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY(g2 * 8.0f);
                Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)) * 2.0f);
                quaternionf.mul((Quaternionfc)quaternionf2);
                PoseStack matrixStack = context.m_280168_();
                Lighting.m_166384_();
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)x, (double)y, 150.0);
                float scaling = (float)((double)screen.f_96544_ * 0.3);
                matrixStack.m_252931_(new Matrix4f().scaling(scaling, scaling, -scaling));
                matrixStack.m_252781_(quaternionf);
                matrixStack.m_85836_();
                matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
                matrixStack.m_252880_(0.0f, -1.501f, 0.0f);
                VertexConsumer buffer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
                if (buffer != null) {
                    this.renderBoxes(matrixStack, buffer, this.root);
                }
                matrixStack.m_85849_();
            }
        }

        private void renderBoxes(PoseStack matrices, VertexConsumer vertices, ModelPart modelPart) {
            if (!(!modelPart.f_104207_ || modelPart.f_104212_.isEmpty() && modelPart.f_104213_.isEmpty())) {
                matrices.m_85836_();
                modelPart.m_104299_(matrices);
                if (!modelPart.f_233556_) {
                    for (ModelPart.Cube cuboid : modelPart.f_104212_) {
                        AABB box = new AABB((double)(cuboid.f_104335_ / 16.0f), (double)(cuboid.f_104336_ / 16.0f), (double)(cuboid.f_104337_ / 16.0f), (double)(cuboid.f_104338_ / 16.0f), (double)(cuboid.f_104339_ / 16.0f), (double)(cuboid.f_104340_ / 16.0f));
                        LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)vertices, (AABB)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                for (ModelPart modelPartChildren : modelPart.f_104213_.values()) {
                    this.renderBoxes(matrices, vertices, modelPartChildren);
                }
                matrices.m_85849_();
            }
        }
    }
}

