/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.ItemUseOnBlock;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IRecolorable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

class DyeBehavior
implements ItemUseOnBlock {
    DyeBehavior() {
    }

    @Override
    public boolean altersWorld() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.DYE_BLOCKS.get();
    }

    @Override
    public boolean appliesToItem(Item item) {
        return ForgeHelper.getColor((ItemStack)new ItemStack((ItemLike)item)) != null || item == ModRegistry.DYE_BOTTLE_ITEM.get();
    }

    @Override
    public InteractionResult tryPerformingAction(Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        DyeColor color;
        BlockPos pos = hit.m_82425_();
        BlockState state = level.m_8055_(pos);
        boolean isBottle = false;
        if (stack.m_41720_() instanceof DyeBottleItem) {
            isBottle = true;
            color = DyeBottleItem.getClosestDye(stack);
        } else {
            color = ForgeHelper.getColor((ItemStack)stack);
        }
        if (this.recolor(level, pos, state, color)) {
            if (isBottle) {
                level.m_5594_(player, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.m_5594_(player, pos, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.m_7500_()) {
                    if (isBottle) {
                        Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)Items.f_42590_.m_7968_());
                    } else {
                        stack.m_41774_(1);
                    }
                }
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private boolean recolor(Level level, BlockPos pos, BlockState state, DyeColor color) {
        Block block = state.m_60734_();
        if (block instanceof IRecolorable) {
            IRecolorable recolorable = (IRecolorable)block;
            if (recolorable.isDefaultColor(level, pos, state)) {
                return recolorable.tryRecolor(level, pos, state, color);
            }
        } else {
            Block newBlock = BlocksColorAPI.changeColor((Block)state.m_60734_(), (DyeColor)color);
            if (newBlock != null && !state.m_60713_(newBlock) && BlocksColorAPI.isDefaultColor((Block)state.m_60734_())) {
                BlockState newState = newBlock.m_152465_(state);
                if (newState.m_245147_()) {
                    level.m_46597_(pos, newState);
                }
                return true;
            }
        }
        return false;
    }
}

