/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.RPLScreenShakeHandlerClient;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundCheckChannelVersionPacket;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundPreciseMotionSyncPacket;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundShakeScreenPacket;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundSyncBurstSubProjectilesPacket;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurst;

public class RPLClientHandlers {
    public static void checkVersion(ClientboundCheckChannelVersionPacket packet) {
        if ("3.0.0".equals(packet.serverVersion())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null) {
            mc.m_91403_().m_7026_((Component)Component.m_237113_((String)"Ritchie's Projectile Library on the client uses a different network format than the server.").m_130946_(" Please use a matching format."));
        }
    }

    public static void syncPreciseMotion(ClientboundPreciseMotionSyncPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(packet.entityId());
        if (entity == null) {
            return;
        }
        int lerpSteps = packet.lerpSteps();
        if (lerpSteps < 1) {
            lerpSteps = 3;
        }
        entity.m_6453_(packet.x(), packet.y(), packet.z(), packet.yRot(), packet.xRot(), lerpSteps, false);
        entity.m_20334_(packet.dx(), packet.dy(), packet.dz());
        entity.m_6853_(packet.onGround());
    }

    public static void shakeScreen(ClientboundShakeScreenPacket packet) {
        if (packet.modHandlerId() == null) {
            RPLScreenShakeHandlerClient.addShakeEffect(packet.effect());
        } else {
            RPLScreenShakeHandlerClient.addShakeEffect(packet.modHandlerId(), packet.effect());
        }
    }

    public static void addBurstSubProjectileData(ClientboundSyncBurstSubProjectilesPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(pkt.entityId());
        if (entity instanceof ProjectileBurst) {
            ProjectileBurst burst = (ProjectileBurst)entity;
            burst.updateClientData(pkt.age(), pkt.subProjectiles());
        } else {
            RitchiesProjectileLib.LOGGER.error("Invalid ClientboundSyncBurstSubProjectilesPacket for non-projectile burst entity: " + String.valueOf(entity));
        }
    }
}

