/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.input;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.GenericInputScreen;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.KeyboardInputScreen;
import com.getitemfromblock.create_tweaked_controllers.input.GenericInput;
import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.AllKeys;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class KeyboardInput
implements GenericInput {
    public int key = -1;
    public boolean invertValue = false;

    public KeyboardInput(int key) {
        this.key = key;
    }

    public KeyboardInput() {
    }

    @Override
    public boolean GetButtonValue() {
        if (!this.IsInputValid()) {
            return this.invertValue;
        }
        return this.invertValue ? !AllKeys.isKeyDown((int)this.key) : AllKeys.isKeyDown((int)this.key);
    }

    @Override
    public float GetAxisValue() {
        return this.GetButtonValue() ? 1.0f : 0.0f;
    }

    @Override
    public MutableComponent GetDisplayName() {
        return this.key >= 0 ? InputConstants.m_84827_((int)this.key, (int)0).m_84875_().m_6879_() : CreateTweakedControllers.translateDirectRaw("key.keyboard.unknown", new Object[0]);
    }

    @Override
    public boolean IsInputValid() {
        return this.key != -1;
    }

    @Override
    public void Serialize(DataOutputStream buf) throws IOException {
        buf.writeBoolean(this.invertValue);
        buf.writeInt(this.key);
    }

    @Override
    public void Deserialize(DataInputStream buf) throws IOException {
        this.invertValue = buf.readBoolean();
        this.key = buf.readInt();
    }

    @Override
    public GenericInput.InputType GetType() {
        return GenericInput.InputType.KEYBOARD_KEY;
    }

    @Override
    public int GetValue() {
        return this.key;
    }

    @Override
    public GenericInputScreen OpenConfigScreen(Screen previous, Component comp) {
        return new KeyboardInputScreen(previous, comp, this);
    }
}

