/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.gui;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.config.ModClientConfig;
import com.getitemfromblock.create_tweaked_controllers.controller.ControlType;
import com.getitemfromblock.create_tweaked_controllers.controller.TweakedControlsUtil;
import com.getitemfromblock.create_tweaked_controllers.gui.ControllerButton;
import com.getitemfromblock.create_tweaked_controllers.gui.ControllerButtonRenderer;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.ColoredButton;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.InputList;
import com.getitemfromblock.create_tweaked_controllers.gui.JoystickIcon;
import com.getitemfromblock.create_tweaked_controllers.gui.ModGuiTextures;
import com.getitemfromblock.create_tweaked_controllers.gui.ModIcons;
import com.getitemfromblock.create_tweaked_controllers.gui.PlainRect;
import com.getitemfromblock.create_tweaked_controllers.input.GamepadInputs;
import com.getitemfromblock.create_tweaked_controllers.input.JoystickAxisInput;
import com.getitemfromblock.create_tweaked_controllers.input.JoystickButtonInput;
import com.getitemfromblock.create_tweaked_controllers.input.JoystickInputs;
import com.getitemfromblock.create_tweaked_controllers.input.KeyboardInput;
import com.getitemfromblock.create_tweaked_controllers.input.MouseAxisInput;
import com.getitemfromblock.create_tweaked_controllers.input.MouseButtonInput;
import com.getitemfromblock.create_tweaked_controllers.input.MouseCursorHandler;
import com.mojang.blaze3d.Blaze3D;
import java.util.function.Consumer;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.ConfirmationScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;

public class ModControllerConfigScreen
extends AbstractSimiScreen {
    protected final Screen parent;
    protected ModGuiTextures background;
    private JoystickIcon lStick;
    private JoystickIcon rStick;
    private ControllerButton[] controllerButtons;
    private PlainRect[] triggerAxis;
    private int selectedInput = -1;
    private InputList inputBindsList;
    private boolean saved = true;

    public ModControllerConfigScreen(Screen p) {
        this.parent = p;
        this.background = ModGuiTextures.CONTROLLER_BACKGROUND;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.Populate();
    }

    public void m_86600_() {
    }

    private void attemptBackstep() {
        if (this.saved) {
            ScreenOpener.open((Screen)this.parent);
            return;
        }
        this.showLeavingPrompt(success -> {
            if (success == ConfirmationScreen.Response.Cancel) {
                return;
            }
            if (success == ConfirmationScreen.Response.Confirm) {
                ScreenOpener.open((Screen)this.parent);
            }
        });
    }

    protected void showLeavingPrompt(Consumer<ConfirmationScreen.Response> action) {
        ConfirmationScreen screen = new ConfirmationScreen().centered().withThreeActions(action).addText(FormattedText.m_130775_((String)"Leaving with unsaved change(s) for this config"));
        screen.open((Screen)this);
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.selectedInput != -1) {
            TweakedControlsUtil.profile.layout[this.selectedInput] = new MouseButtonInput(button);
            this.selectedInput = -1;
            TweakedControlsUtil.profile.UpdateProfileData();
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_7933_(int key, int scan, int modif) {
        if (this.selectedInput != -1) {
            TweakedControlsUtil.profile.layout[this.selectedInput] = key == 256 ? null : new KeyboardInput(key);
            TweakedControlsUtil.profile.UpdateProfileData();
            this.selectedInput = -1;
            return true;
        }
        return super.m_7933_(key, scan, modif);
    }

    protected void renderSelectedInput() {
        if (this.selectedInput == -1) {
            return;
        }
        float val = (Mth.m_14031_((float)((float)Blaze3D.m_83640_() * (float)Math.PI * 4.0f)) + 1.0f) / 2.0f;
        if (this.selectedInput < 15) {
            this.controllerButtons[this.selectedInput].SetColorFactor(Mth.m_14179_((float)val, (float)0.19607843f, (float)1.0f));
        } else if (this.selectedInput < 23) {
            int vx = 0;
            int vy = 0;
            switch (this.selectedInput) {
                case 15: {
                    vx = (int)(val * 10.0f);
                    break;
                }
                case 16: {
                    vx = (int)(-val * 10.0f);
                    break;
                }
                case 17: {
                    vy = (int)(val * 10.0f);
                    break;
                }
                case 18: {
                    vy = (int)(-val * 10.0f);
                    break;
                }
                case 19: {
                    vx = (int)(val * 10.0f);
                    break;
                }
                case 20: {
                    vx = (int)(-val * 10.0f);
                    break;
                }
                case 21: {
                    vy = (int)(val * 10.0f);
                    break;
                }
                default: {
                    vy = (int)(-val * 10.0f);
                }
            }
            if (this.selectedInput < 19) {
                this.lStick.move(vx, vy);
                this.controllerButtons[9].move(vx, vy);
            } else {
                this.rStick.move(vx, vy);
                this.controllerButtons[10].move(vx, vy);
            }
        } else {
            this.triggerAxis[this.selectedInput - 23].SetValue(val);
        }
    }

    protected void renderWindow(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        int i;
        TweakedControlsUtil.GuiUpdate();
        if (this.selectedInput != -1 && (this.HandleMouseMovement() || this.HandleJoystickButtons() || this.HandleJoystickAxis())) {
            this.selectedInput = -1;
            this.saved = false;
            TweakedControlsUtil.profile.UpdateProfileData();
        }
        this.inputBindsList.m_88315_(ms, mouseX, mouseY, partialTicks);
        int x = (this.f_96543_ - this.background.width) / 2;
        int y = 10;
        this.background.render(ms, x, y);
        Vec2 v = new Vec2(GamepadInputs.axis[0], GamepadInputs.axis[1]);
        if (v.m_165912_() > 1.0f) {
            v = v.m_165902_();
        }
        int vx = (int)(v.f_82470_ * 10.0f);
        int vy = (int)(v.f_82471_ * 10.0f);
        this.lStick.move(vx, vy);
        this.controllerButtons[9].move(vx, vy);
        v = new Vec2(GamepadInputs.axis[2], GamepadInputs.axis[3]);
        if (v.m_165912_() > 1.0f) {
            v = v.m_165902_();
        }
        vx = (int)(v.f_82470_ * 10.0f);
        vy = (int)(v.f_82471_ * 10.0f);
        this.rStick.move(vx, vy);
        this.controllerButtons[10].move(vx, vy);
        for (i = 0; i < this.triggerAxis.length; ++i) {
            this.triggerAxis[i].SetValue((GamepadInputs.axis[i + 4] + 1.0f) / 2.0f);
        }
        for (i = 0; i < this.controllerButtons.length; ++i) {
            this.controllerButtons[i].SetColorFactor(GamepadInputs.buttons[i] ? 1.0f : 0.19607843f);
        }
        this.renderSelectedInput();
    }

    public void SetActiveInput(int index) {
        this.selectedInput = index;
        MouseCursorHandler.ResetCenter();
        JoystickInputs.StoreAxisValues();
    }

    public int GetActiveInput() {
        return this.selectedInput;
    }

    private boolean HandleMouseMovement() {
        float deltaM = MouseCursorHandler.GetX(false);
        float deltaM2 = MouseCursorHandler.GetY(false);
        boolean isY = false;
        if (Math.abs(deltaM) < Math.abs(deltaM2)) {
            deltaM = deltaM2;
            isY = true;
        }
        if (Math.abs(deltaM) > 250.0f) {
            TweakedControlsUtil.profile.layout[this.selectedInput] = new MouseAxisInput(isY, 0.0f, Math.copySign(1000.0f, deltaM), false);
            return true;
        }
        return false;
    }

    private boolean HandleJoystickButtons() {
        if (!JoystickInputs.HasJoystick()) {
            return false;
        }
        int val = JoystickInputs.GetFirstButton();
        if (val < 0) {
            return false;
        }
        TweakedControlsUtil.profile.layout[this.selectedInput] = new JoystickButtonInput(val);
        return true;
    }

    private boolean HandleJoystickAxis() {
        if (!JoystickInputs.HasJoystick()) {
            return false;
        }
        int val = JoystickInputs.GetFirstAxis();
        if (val < 0) {
            return false;
        }
        float start = JoystickInputs.GetStoredAxis(val);
        float dest = JoystickInputs.GetAxis(val);
        if (Math.abs(start) > 0.5f) {
            start = Math.copySign(1.0f, start);
            dest = -start;
        } else {
            start = 0.0f;
            dest = Math.copySign(1.0f, dest);
        }
        TweakedControlsUtil.profile.layout[this.selectedInput] = new JoystickAxisInput(val, start, dest);
        return true;
    }

    private void Populate() {
        int i;
        this.inputBindsList = new InputList(this, this.f_96541_);
        this.m_7787_((GuiEventListener)this.inputBindsList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, p_193996_ -> ScreenOpener.open((Screen)this.parent)).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 29, 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)new ColoredButton(this.f_96543_ / 2 - 155 + 100, this.f_96544_ - 29, 90, 20, (Component)CreateTweakedControllers.translateDirect("gui_config_reset_all", new Object[0]), p_193999_ -> {
            TweakedControlsUtil.profile.InitDefaultLayout(ControlType.KEYBOARD_MOUSE);
            TweakedControlsUtil.profile.UpdateProfileData();
        }, new Vector3f(1.0f, 0.3f, 0.3f)));
        this.m_142416_((GuiEventListener)new ColoredButton(this.f_96543_ / 2 - 155 + 200, this.f_96544_ - 29, 40, 20, (Component)CreateTweakedControllers.translateDirect("gui_config_save", new Object[0]), p_193996_ -> {
            TweakedControlsUtil.profile.Save(0);
            this.saved = true;
        }, new Vector3f(0.5f, 0.5f, 1.0f)));
        this.m_142416_((GuiEventListener)new ColoredButton(this.f_96543_ / 2 - 155 + 250, this.f_96544_ - 29, 40, 20, (Component)CreateTweakedControllers.translateDirect("gui_config_load", new Object[0]), p_193996_ -> TweakedControlsUtil.profile.Load(0), new Vector3f(0.5f, 0.5f, 1.0f)));
        int x = (this.f_96543_ - this.background.width) / 2;
        int y = 10;
        this.lStick = new JoystickIcon(x + 21, y + 34, ModIcons.I_LEFT_JOYSTICK);
        this.rStick = new JoystickIcon(x + 86, y + 66, ModIcons.I_RIGHT_JOYSTICK);
        this.m_169394_((Renderable)this.lStick);
        this.m_169394_((Renderable)this.rStick);
        this.controllerButtons = new ControllerButton[15];
        switch ((ModClientConfig.ControllerLayoutType)((Object)ModClientConfig.CONTROLLER_LAYOUT_TYPE.get())) {
            case NINTENDO: {
                this.controllerButtons[0] = new ControllerButton(x + 113, y + 49, ControllerButtonRenderer.B_B, new Vector3f(1.0f, 1.0f, 0.0f));
                this.controllerButtons[1] = new ControllerButton(x + 124, y + 38, ControllerButtonRenderer.B_A, new Vector3f(1.0f, 0.0f, 0.0f));
                this.controllerButtons[2] = new ControllerButton(x + 102, y + 38, ControllerButtonRenderer.B_Y, new Vector3f(0.0f, 1.0f, 0.0f));
                this.controllerButtons[3] = new ControllerButton(x + 113, y + 27, ControllerButtonRenderer.B_X, new Vector3f(0.0f, 0.25f, 1.0f));
                break;
            }
            case PLAYSTATION: {
                this.controllerButtons[0] = new ControllerButton(x + 113, y + 49, ControllerButtonRenderer.B_CROSS, new Vector3f(0.49f, 0.706f, 0.914f));
                this.controllerButtons[1] = new ControllerButton(x + 124, y + 38, ControllerButtonRenderer.B_CIRCLE, new Vector3f(1.0f, 0.4f, 0.4f));
                this.controllerButtons[2] = new ControllerButton(x + 102, y + 38, ControllerButtonRenderer.B_SQUARE, new Vector3f(1.0f, 0.412f, 0.973f));
                this.controllerButtons[3] = new ControllerButton(x + 113, y + 27, ControllerButtonRenderer.B_TRIANGLE, new Vector3f(0.243f, 0.89f, 0.631f));
                break;
            }
            default: {
                this.controllerButtons[0] = new ControllerButton(x + 113, y + 49, ControllerButtonRenderer.B_A, new Vector3f(0.0f, 1.0f, 0.0f));
                this.controllerButtons[1] = new ControllerButton(x + 124, y + 38, ControllerButtonRenderer.B_B, new Vector3f(1.0f, 0.0f, 0.0f));
                this.controllerButtons[2] = new ControllerButton(x + 102, y + 38, ControllerButtonRenderer.B_X, new Vector3f(0.0f, 0.0f, 1.0f));
                this.controllerButtons[3] = new ControllerButton(x + 113, y + 27, ControllerButtonRenderer.B_Y, new Vector3f(1.0f, 1.0f, 0.0f));
            }
        }
        this.controllerButtons[4] = new ControllerButton(x + 38, y + 1, ControllerButtonRenderer.B_L, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[5] = new ControllerButton(x + 100, y + 1, ControllerButtonRenderer.B_R, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[6] = new ControllerButton(x + 58, y + 38, ControllerButtonRenderer.B_SELECT, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[7] = new ControllerButton(x + 80, y + 38, ControllerButtonRenderer.B_START, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[8] = new ControllerButton(x + 69, y + 27, ControllerButtonRenderer.B_MIDDLE, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[9] = new ControllerButton(x + 26, y + 39, ControllerButtonRenderer.B_LJ, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[10] = new ControllerButton(x + 91, y + 71, ControllerButtonRenderer.B_RJ, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[11] = new ControllerButton(x + 47, y + 60, ControllerButtonRenderer.B_UP, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[12] = new ControllerButton(x + 58, y + 71, ControllerButtonRenderer.B_RIGHT, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[13] = new ControllerButton(x + 47, y + 82, ControllerButtonRenderer.B_DOWN, new Vector3f(1.0f, 0.0f, 0.0f));
        this.controllerButtons[14] = new ControllerButton(x + 36, y + 71, ControllerButtonRenderer.B_LEFT, new Vector3f(1.0f, 0.0f, 0.0f));
        for (i = 0; i < this.controllerButtons.length; ++i) {
            this.m_169394_((Renderable)this.controllerButtons[i]);
        }
        this.triggerAxis = new PlainRect[2];
        this.triggerAxis[0] = new PlainRect(x + 2, y + 3, 0, 5, x + 2, y + 3, 32, 5, new Vector3f(1.0f, 0.0f, 0.0f));
        this.triggerAxis[1] = new PlainRect(x + 145, y + 3, 0, 5, x + 145, y + 3, -32, 5, new Vector3f(1.0f, 0.0f, 0.0f));
        for (i = 0; i < this.triggerAxis.length; ++i) {
            this.m_169394_((Renderable)this.triggerAxis[i]);
        }
    }

    public boolean m_7043_() {
        return true;
    }
}

