/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.colossal_cogwheel;

import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.content.colossal_cogwheel.ColossalCogwheelBlockEntity;
import com.petrolpark.petrolsparts.content.colossal_cogwheel.ColossalCogwheelBlockItem;
import com.petrolpark.util.Lang;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.render.MultiPosDestructionHandler;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VoxelShaper;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.joml.Matrix2d;

public class ColossalCogwheelBlock
extends KineticBlock
implements IBE<ColossalCogwheelBlockEntity>,
IProxyHoveringInformation {
    public static EnumProperty<Position.Clock> POSITION_CLOCK = EnumProperty.m_61587_((String)"position_clock", Position.Clock.class);
    public static EnumProperty<Position.Type> POSITION_TYPE = EnumProperty.m_61587_((String)"position_type", Position.Type.class);

    public ColossalCogwheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(POSITION_CLOCK, (Comparable)((Object)Position.Clock.TWELVE))).m_61124_(POSITION_TYPE, (Comparable)((Object)Position.Type.MIDDLE))).m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)Direction.Axis.Y));
    }

    public static BlockPos getRelativeCenterPosition(BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        return ((Position.Type)((Object)state.m_61143_(ColossalCogwheelBlock.POSITION_TYPE))).relativeCenterPos.apply(axis, ((Position.Clock)((Object)state.m_61143_(POSITION_CLOCK))).getDirection(axis));
    }

    public static BlockPos getControllerPosition(BlockPos pos, BlockState state) {
        return pos.m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(state)).m_121955_((Vec3i)Position.getRelativeControllerPosition((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS)));
    }

    public static boolean isController(BlockState state) {
        return state.m_60734_() instanceof ColossalCogwheelBlock && state.m_61143_(POSITION_CLOCK) == Position.Clock.TWELVE && state.m_61143_(POSITION_TYPE) == Position.Type.MIDDLE;
    }

    public static boolean stillValid(BlockGetter level, BlockPos pos, BlockState state) {
        BlockState controllerState = level.m_8055_(ColossalCogwheelBlock.getControllerPosition(pos, state));
        return ColossalCogwheelBlock.isController(controllerState) && controllerState.m_61143_((Property)RotatedPillarKineticBlock.AXIS) == state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        Position.Clock clockPos = (Position.Clock)((Object)state.m_61143_(POSITION_CLOCK));
        if (axis == Direction.Axis.X) {
            clockPos = clockPos.getOpposite();
        }
        if (axis == Direction.Axis.Z && (clockPos == Position.Clock.TWELVE || clockPos == Position.Clock.SIX)) {
            clockPos = clockPos.getOpposite();
        }
        return ((Position.Type)((Object)state.m_61143_(POSITION_TYPE))).getShape(clockPos, axis);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        if (!ColossalCogwheelBlock.isController(state) && ColossalCogwheelBlock.stillValid((BlockGetter)level, clickedPos, state)) {
            BlockPos masterPos = ColossalCogwheelBlock.getControllerPosition(clickedPos, state);
            context = new UseOnContext(level, context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), masterPos, context.m_43721_()));
            state = level.m_8055_(masterPos);
        }
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IPlacementHelper helper;
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if ((ICogWheel.isSmallCogItem((ItemStack)stack) || ICogWheel.isLargeCogItem((ItemStack)stack)) && (helper = PlacementHelpers.get((int)((Integer)((ColossalCogwheelBlockItem)this.m_5456_()).onColossalPlacementHelpers.get(ICogWheel.isLargeCogItem((ItemStack)stack))))).matchesItem(stack) && helper.matchesState(state)) {
            helper.getOffset(player, level, state, pos, hit, stack).placeInWorld(level, (BlockItem)stack.m_41720_(), player, hand, hit);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)context.m_7820_().m_122434_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (ColossalCogwheelBlock.isController(state) && !level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (ColossalCogwheelBlock.stillValid((BlockGetter)level, pos, state)) {
            level.m_46961_(ColossalCogwheelBlock.getControllerPosition(pos, state), true);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        if (ColossalCogwheelBlock.isController(state)) {
            return super.m_49635_(state, params);
        }
        return Collections.emptyList();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (ColossalCogwheelBlock.stillValid((BlockGetter)level, pos, state)) {
            BlockPos masterPos = ColossalCogwheelBlock.getControllerPosition(pos, state);
            level.m_6801_(masterPos.hashCode(), masterPos, -1);
            if (!level.m_5776_() && player.m_7500_()) {
                level.m_46961_(masterPos, false);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        Level level;
        if (ColossalCogwheelBlock.stillValid((BlockGetter)levelAccessor, currentPos, state = super.m_7417_(state, facing, facingState, levelAccessor, currentPos, facingPos))) {
            BlockPos masterPos = ColossalCogwheelBlock.getControllerPosition(currentPos, state);
            if (!levelAccessor.m_183326_().m_183582_(masterPos, (Object)((Block)PetrolsPartsBlocks.COLOSSAL_COGWHEEL.get()))) {
                levelAccessor.m_186460_(masterPos, (Block)PetrolsPartsBlocks.COLOSSAL_COGWHEEL.get(), 1);
            }
            return state;
        }
        if (!(levelAccessor instanceof Level) || (level = (Level)levelAccessor).m_5776_()) {
            return state;
        }
        if (!level.m_183326_().m_183582_(currentPos, (Object)this)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (ColossalCogwheelBlock.isController(state)) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
            for (Position.Clock posClock : Position.Clock.values()) {
                for (Position.Type posType : Position.Type.values()) {
                    if (posClock == Position.Clock.TWELVE && posType == Position.Type.MIDDLE) continue;
                    BlockPos targetPos = pos.m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(state)).m_121996_((Vec3i)posType.relativeCenterPos.apply(axis, posClock.getDirection(axis)));
                    BlockState targetState = (BlockState)((BlockState)((BlockState)PetrolsPartsBlocks.COLOSSAL_COGWHEEL.getDefaultState().m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis)).m_61124_(POSITION_CLOCK, (Comparable)((Object)posClock))).m_61124_(POSITION_TYPE, (Comparable)((Object)posType));
                    if (level.m_8055_(targetPos).equals(targetState)) continue;
                    if (!level.m_8055_(targetPos).m_247087_()) {
                        level.m_46961_(pos, true);
                        return;
                    }
                    level.m_46597_(targetPos, targetState);
                }
            }
        } else if (!ColossalCogwheelBlock.stillValid((BlockGetter)level, pos, state)) {
            level.m_46961_(pos, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(MessagePassingQueue.Consumer<IClientBlockExtensions> consumer) {
        consumer.accept((Object)new RenderProperties());
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{RotatedPillarKineticBlock.AXIS}).m_61104_(new Property[]{POSITION_CLOCK}).m_61104_(new Property[]{POSITION_TYPE});
    }

    public RenderShape m_7514_(BlockState state) {
        return ColossalCogwheelBlock.isController(state) ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.INVISIBLE;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
    }

    public Class<ColossalCogwheelBlockEntity> getBlockEntityClass() {
        return ColossalCogwheelBlockEntity.class;
    }

    public BlockEntityType<? extends ColossalCogwheelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)PetrolsPartsBlockEntityTypes.COLOSSAL_COGWHEEL.get();
    }

    public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        return ColossalCogwheelBlock.stillValid((BlockGetter)level, pos, state) ? pos.m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(state)) : pos;
    }

    public static interface Position
    extends StringRepresentable {
        public static BlockPos getRelativeControllerPosition(Direction.Axis axis) {
            return BlockPos.f_121853_.m_121996_((Vec3i)Type.MIDDLE.relativeCenterPos.apply(axis, Clock.TWELVE.getDirection(axis)));
        }

        public static enum Type implements Position
        {
            ANTICLOCKWISE((a, d) -> BlockPos.f_121853_.m_5484_(d.m_122424_(), 2).m_121945_(d.m_175362_(a)), new Matrix2d(0.0, 14.0, 0.0, 12.0)),
            MIDDLE((a, d) -> BlockPos.f_121853_.m_5484_(d.m_122424_(), 2), new Matrix2d(0.0, 16.0, 2.0, 14.0)),
            CLOCKWISE((a, d) -> BlockPos.f_121853_.m_5484_(d.m_122424_(), 2).m_121945_(d.m_175364_(a)), new Matrix2d(2.0, 16.0, 0.0, 12.0)),
            INSIDE((a, d) -> BlockPos.f_121853_.m_121945_(d.m_122424_()).m_121945_(d.m_175364_(a)), new Matrix2d(0.0, 11.0, 5.0, 16.0));

            public final BiFunction<Direction.Axis, Direction, BlockPos> relativeCenterPos;
            public final Matrix2d[] untransformedShapeCuboids;
            public final EnumMap<Clock, VoxelShaper> shapes;

            private Type(BiFunction<Direction.Axis, Direction, BlockPos> relativeCenterPos, Matrix2d ... untransformedShapeCuboids) {
                this.relativeCenterPos = relativeCenterPos;
                this.untransformedShapeCuboids = untransformedShapeCuboids;
                this.shapes = new EnumMap(Clock.class);
            }

            public String m_7912_() {
                return Lang.asId((String)this.name());
            }

            public VoxelShape getShape(Clock clockPos, Direction.Axis axis) {
                return this.shapes.computeIfAbsent(clockPos, c -> {
                    AllShapes.Builder shapeBuilder = new AllShapes.Builder(Shapes.m_83040_());
                    for (Matrix2d untransformedCuboid : this.untransformedShapeCuboids) {
                        Matrix2d cuboid = (Matrix2d)c.voxelCuboidTransform.apply(untransformedCuboid);
                        shapeBuilder.add(cuboid.m00, 3.0, cuboid.m10, cuboid.m01, 13.0, cuboid.m11);
                    }
                    return shapeBuilder.forAxis();
                }).get(axis);
            }
        }

        public static enum Clock implements Position
        {
            TWELVE(Direction.UP, Direction.SOUTH, Direction.UP, m -> m),
            THREE(Direction.SOUTH, Direction.EAST, Direction.EAST, m -> new Matrix2d(m.m10, m.m11, 16.0 - m.m01, 16.0 - m.m00)),
            SIX(Direction.DOWN, Direction.NORTH, Direction.DOWN, m -> new Matrix2d(16.0 - m.m01, 16.0 - m.m00, 16.0 - m.m11, 16.0 - m.m10)),
            NINE(Direction.NORTH, Direction.WEST, Direction.WEST, m -> new Matrix2d(16.0 - m.m11, 16.0 - m.m10, m.m00, m.m01));

            private final Direction xDirection;
            private final Direction yDirection;
            private final Direction zDirection;
            private final UnaryOperator<Matrix2d> voxelCuboidTransform;

            private Clock(Direction xDirection, Direction yDirection, Direction zDirection, UnaryOperator<Matrix2d> voxelCuboidTransform) {
                this.xDirection = xDirection;
                this.yDirection = yDirection;
                this.zDirection = zDirection;
                this.voxelCuboidTransform = voxelCuboidTransform;
            }

            public Direction getDirection(Direction.Axis axis) {
                switch (axis) {
                    case X: {
                        return this.xDirection;
                    }
                    case Y: {
                        return this.yDirection;
                    }
                }
                return this.zDirection;
            }

            public String m_7912_() {
                return Lang.asId((String)this.name());
            }

            public Clock getClockwise(boolean anti) {
                return Clock.values()[(Clock.values().length + this.ordinal() + (anti ? -1 : 1)) % Clock.values().length];
            }

            public Clock getOpposite() {
                return Clock.values()[(this.ordinal() + 2) % Clock.values().length];
            }
        }
    }

    public static class RenderProperties
    implements IClientBlockExtensions,
    MultiPosDestructionHandler {
        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            return true;
        }

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)target;
                BlockPos targetPos = bhr.m_82425_();
                if (ColossalCogwheelBlock.stillValid((BlockGetter)level, targetPos, state)) {
                    manager.m_107367_(ColossalCogwheelBlock.getControllerPosition(targetPos, state), bhr.m_82434_());
                }
                return true;
            }
            return super.addHitEffects(state, level, target, manager);
        }

        @Nullable
        public Set<BlockPos> getExtraPositions(ClientLevel level, BlockPos pos, BlockState blockState, int progress) {
            if (!ColossalCogwheelBlock.stillValid((BlockGetter)level, pos, blockState)) {
                return null;
            }
            return Collections.singleton(ColossalCogwheelBlock.getControllerPosition(pos, blockState));
        }
    }

    public record Connection(boolean toLargeCog, float ratio) {
        public static Set<Pair<BlockPos, Connection>> getAll(BlockPos centerPos, Direction.Axis axis) {
            HashSet<Pair<BlockPos, Connection>> set = new HashSet<Pair<BlockPos, Connection>>(Type.values().length * Position.Clock.values().length);
            for (Position.Clock posClock : Position.Clock.values()) {
                for (Type connectionType : Type.values()) {
                    set.add((Pair<BlockPos, Connection>)Pair.of((Object)centerPos.m_121996_((Vec3i)connectionType.relativeCenterPos.apply(axis, posClock.getDirection(axis))), (Object)connectionType.connection));
                }
            }
            return set;
        }

        public static enum Type {
            INSIDE_SMALL(new Connection(false, 3.0f), (a, d) -> BlockPos.f_121853_.m_5484_(d.m_122424_(), 1)),
            CORNER_SMALL(new Connection(false, -6.0f), (a, d) -> BlockPos.f_121853_.m_5484_(d.m_122424_(), 2).m_5484_(d.m_175362_(a), 2)),
            ANTICLOCKWISE_LARGE(new Connection(true, -3.0f), (a, d) -> BlockPos.f_121853_.m_5484_(d.m_122424_(), 3).m_121945_(d.m_175362_(a))),
            CLOCKWISE_LARGE(new Connection(true, -3.0f), (a, d) -> BlockPos.f_121853_.m_5484_(d.m_122424_(), 3).m_121945_(d.m_175364_(a)));

            public final Connection connection;
            public final BiFunction<Direction.Axis, Direction, BlockPos> relativeCenterPos;

            private Type(Connection connection, BiFunction<Direction.Axis, Direction, BlockPos> relativeCenterPos) {
                this.connection = connection;
                this.relativeCenterPos = relativeCenterPos;
            }
        }
    }
}

