/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.foundation.mirror.PatternSchematicHandler;
import com.cak.pattern_schematics.foundation.mirror.StaticRenderers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class CloneSchematicOutlineRenderer {
    public static void renderCloneGridLines(PoseStack ms, PatternSchematicHandler schematicHandler, SuperRenderTypeBuffer buffer) {
        if (schematicHandler.cloneScaleMin.equals((Object)new Vec3i(0, 0, 0)) && schematicHandler.cloneScaleMax.equals((Object)new Vec3i(0, 0, 0))) {
            return;
        }
        ms.m_85836_();
        AABBOutline outline = schematicHandler.getGreaterOutline();
        outline.setBounds(schematicHandler.calculateGreaterOutlineBounds());
        outline.getParams().colored(10920367).lineWidth(0.0625f);
        outline.render(ms, buffer, Vec3.f_82478_, AnimationTickHolder.getPartialTicks());
        Vec3i min = schematicHandler.cloneScaleMin;
        Vec3i max = schematicHandler.cloneScaleMax;
        AABB bounds = schematicHandler.bounds;
        Vec3 scale = new Vec3(bounds.m_82362_(), bounds.m_82376_(), bounds.m_82385_());
        Vector4f color = new Vector4f(0.6484375f, 0.62890625f, 0.68359375f, 1.0f);
        for (Direction.Axis axis : Iterate.axes) {
            List<Direction.Axis> secondaries = axis == Direction.Axis.X ? List.of(Direction.Axis.Y, Direction.Axis.Z) : (axis == Direction.Axis.Y ? List.of(Direction.Axis.Z, Direction.Axis.X) : List.of(Direction.Axis.X, Direction.Axis.Y));
            Direction.Axis secondaryA = secondaries.get(0);
            Direction.Axis secondaryB = secondaries.get(1);
            double secondaryScaleA = scale.m_82507_(secondaryA);
            double secondaryScaleB = scale.m_82507_(secondaryB);
            Direction secondaryDirectionA = Direction.m_122387_((Direction.Axis)secondaryA, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Direction secondaryDirectionB = Direction.m_122387_((Direction.Axis)secondaryB, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
                Direction currentDirection = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)axisDirection);
                Vec3 surfaceOrigin = axisDirection == Direction.AxisDirection.POSITIVE ? new Vec3(0.0, 0.0, 0.0).m_193103_(axis, (double)(max.m_123304_(axis) + 1) * scale.m_82507_(axis)) : new Vec3(0.0, 0.0, 0.0).m_193103_(axis, (double)min.m_123304_(axis) * scale.m_82507_(axis));
                for (int secondaryCellA = min.m_123304_(secondaryA); secondaryCellA <= max.m_123304_(secondaryA); ++secondaryCellA) {
                    for (int secondaryCellB = min.m_123304_(secondaryB); secondaryCellB <= max.m_123304_(secondaryB); ++secondaryCellB) {
                        if (secondaryCellA == 0 && secondaryCellB == 0 && (axisDirection == Direction.AxisDirection.POSITIVE && max.m_123304_(axis) == 0 || axisDirection == Direction.AxisDirection.NEGATIVE && max.m_123304_(axis) == 0)) continue;
                        Vec3 faceMin = surfaceOrigin.m_231075_(secondaryDirectionA, (double)secondaryCellA * secondaryScaleA).m_231075_(secondaryDirectionB, (double)secondaryCellB * secondaryScaleB);
                        StaticRenderers.renderBoxFace(ms.m_85850_(), buffer, true, false, CloneSchematicOutlineRenderer.toVec3f(faceMin), CloneSchematicOutlineRenderer.toVec3f(faceMin.m_231075_(secondaryDirectionA, secondaryScaleA).m_231075_(secondaryDirectionB, secondaryScaleB)), currentDirection, color, 0xF000F0);
                    }
                }
            }
        }
        ms.m_85849_();
    }

    private static Vector3f toVec3f(Vec3 vec) {
        return new Vector3f((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
    }

    public static void applyOutlineModification(SchematicHandler schematicHandler) {
        if (schematicHandler instanceof PatternSchematicHandler) {
            AABBOutline outline = schematicHandler.getOutline();
            PatternSchematicHandler patternSchematicHandler = (PatternSchematicHandler)schematicHandler;
            outline.getParams().colored(9654947).lineWidth(patternSchematicHandler.isRenderingMultiple() ? 0.09375f : 0.0625f);
        }
    }
}

