/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.other;

import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.common.world.storage.tracking.DataProcessors;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataProcessor;
import com.teamabnormals.blueprint.common.world.storage.tracking.SyncType;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.endergetic.common.entity.bolloom.BalloonOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public final class EEDataProcessors {
    private static final IDataProcessor<Map<UUID, BalloonOrder>> ORDER_PROCESSOR = new IDataProcessor<Map<UUID, BalloonOrder>>(){

        public CompoundTag write(Map<UUID, BalloonOrder> map) {
            ListTag entries = new ListTag();
            map.forEach((uuid, balloonOrder) -> {
                CompoundTag entry = new CompoundTag();
                entry.m_128362_("UUID", uuid);
                entry.m_128405_("Order", balloonOrder.ordinal());
                entries.add((Object)entry);
            });
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("Entries", (Tag)entries);
            return compound;
        }

        public Map<UUID, BalloonOrder> read(CompoundTag compound) {
            HashMap map = Maps.newHashMap();
            compound.m_128437_("Entries", 10).forEach(nbt -> {
                CompoundTag entry = (CompoundTag)nbt;
                if (entry.m_128425_("UUID", 11) && entry.m_128425_("Order", 3)) {
                    map.put(entry.m_128342_("UUID"), BalloonOrder.byOrdinal(entry.m_128451_("Order")));
                }
            });
            return map;
        }
    };
    public static final TrackedData<Map<UUID, BalloonOrder>> ORDER_DATA = TrackedData.Builder.create(ORDER_PROCESSOR, Maps::newHashMap).build();
    public static final TrackedData<Integer> CATCHING_COOLDOWN = TrackedData.Builder.create((IDataProcessor)DataProcessors.INT, () -> 0).setSyncType(SyncType.NOPE).build();

    public static void registerTrackedData() {
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("endergetic", "ballooon_order"), ORDER_DATA);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("endergetic", "catching_cooldown"), CATCHING_COOLDOWN);
    }
}

