/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.data.server;

import com.teamabnormals.endergetic.common.advancement.EECriteriaTriggers;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEItems;
import com.teamabnormals.endergetic.core.registry.EEStructureTypes;
import com.teamabnormals.endergetic.core.registry.builtin.EEBiomes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class EEAdvancementProvider
implements ForgeAdvancementProvider.AdvancementGenerator {
    public static ForgeAdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new ForgeAdvancementProvider(output, provider, helper, List.of(new EEAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider provider, Consumer<Advancement> consumer, ExistingFileHelper helper) {
        Advancement poiseForest = EEAdvancementProvider.createAdvancement("find_poise_forest", "end", new ResourceLocation("end/enter_end_gateway"), (ItemLike)EEBlocks.POISMOSS.get(), FrameType.TASK, true, true, false).m_138386_("in_poise_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(EEBiomes.POISE_FOREST))).m_138389_(consumer, "endergetic:end/find_poise_forest");
        Advancement eatBolloomFruit = EEAdvancementProvider.createAdvancement("eat_bolloom_fruit", "end", poiseForest, (ItemLike)EEItems.BOLLOOM_FRUIT.get(), FrameType.TASK, true, true, false).m_138386_("bolloom_fruit", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)EEItems.BOLLOOM_FRUIT.get()))).m_138389_(consumer, "endergetic:end/eat_bolloom_fruit");
        EEAdvancementProvider.createAdvancement("up_up_and_away", "end", eatBolloomFruit, (ItemLike)EEItems.BOLLOOM_BALLOON.get(), FrameType.GOAL, true, true, false).m_138386_("up_up_and_away", (CriterionTriggerInstance)EECriteriaTriggers.UP_UP_AND_AWAY.createInstance()).m_138389_(consumer, "endergetic:end/up_up_and_away");
        EEAdvancementProvider.createAdvancement("tame_booflo", "end", poiseForest, (ItemLike)EEItems.BOOFLO_HIDE.get(), FrameType.GOAL, true, true, false).m_138386_("tamed_booflo", (CriterionTriggerInstance)EECriteriaTriggers.TAME_BOOFLO.createInstance()).m_138389_(consumer, "endergetic:end/tame_booflo");
        EEAdvancementProvider.createAdvancement("obtain_booflo_vest", "end", poiseForest, (ItemLike)EEItems.BOOFLO_VEST.get(), FrameType.GOAL, true, true, false).m_138386_("booflo_vest", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)EEItems.BOOFLO_VEST.get()})).m_138389_(consumer, "endergetic:end/obtain_booflo_vest");
        EEAdvancementProvider.createAdvancement("catch_puff_bug", "end", poiseForest, (ItemLike)EEItems.PUFF_BUG_BOTTLE.get(), FrameType.GOAL, true, true, false).m_138386_("puff_bug_bottle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)EEItems.PUFF_BUG_BOTTLE.get()})).m_138389_(consumer, "endergetic:end/catch_puff_bug");
        Advancement findEetleNest = EEAdvancementProvider.createAdvancement("find_eetle_nest", "end", new ResourceLocation("end/enter_end_gateway"), (ItemLike)EEBlocks.END_CORROCK_BLOCK.get(), FrameType.TASK, true, true, true).m_138386_("in_eetle_nest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(EEStructureTypes.EEStructures.EETLE_NEST))).m_138389_(consumer, "endergetic:end/find_eetle_nest");
        EEAdvancementProvider.createAdvancement("kill_brood_eetle", "end", findEetleNest, (ItemLike)EEBlocks.EETLE_EGG.get(), FrameType.TASK, true, true, true).m_138386_("killed_brood_eetle", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EEEntityTypes.BROOD_EETLE.get()))).m_138389_(consumer, "endergetic:end/kill_brood_eetle");
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemLike icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return EEAdvancementProvider.createAdvancement(name, category, Advancement.Builder.m_138353_().m_138403_(parent), icon, frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, Advancement parent, ItemLike icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(icon, (Component)Component.m_237115_((String)("advancements.endergetic." + category + "." + name + ".title")), (Component)Component.m_237115_((String)("advancements.endergetic." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }
}

