/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.configs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public final class EndergeticPatchConfig
implements FeatureConfiguration {
    public static final Codec<EndergeticPatchConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(config -> Float.valueOf(config.frequency)), (App)Codec.BOOL.fieldOf("search_down").forGetter(config -> config.searchDown)).apply((Applicative)instance, EndergeticPatchConfig::new));
    private final float frequency;
    private final boolean searchDown;

    public EndergeticPatchConfig(float frequency, boolean searchDown) {
        this.frequency = frequency;
        this.searchDown = searchDown;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public boolean shouldSearchDown() {
        return this.searchDown;
    }

    public static BlockPos getPos(WorldGenLevel world, BlockPos pos, boolean searchDown) {
        if (searchDown) {
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            BlockState blockstate = world.m_8055_((BlockPos)mutable);
            while (blockstate.m_60795_() && mutable.m_123342_() > 0) {
                mutable.m_122173_(Direction.DOWN);
                blockstate = world.m_8055_((BlockPos)mutable);
            }
            return mutable;
        }
        return world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos);
    }
}

