/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.ai.glider;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.endergetic.common.entity.eetle.ChargerEetle;
import com.teamabnormals.endergetic.common.entity.eetle.GliderEetle;
import com.teamabnormals.endergetic.core.other.EEDataProcessors;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GliderEetleDropOffGoal
extends Goal {
    private final GliderEetle glider;
    @Nullable
    private Path path;
    @Nullable
    private Vec3 clusterPos;
    @Nullable
    private AABB searchBox;
    private int missingClusterTicks;

    public GliderEetleDropOffGoal(GliderEetle glider) {
        this.glider = glider;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Pair<BlockPos, BlockPos> clusterPosPair;
        LivingEntity target;
        GliderEetle glider = this.glider;
        if (glider.m_217043_().m_188501_() < 0.05f && (target = glider.m_5448_()) != null && target.m_6084_() && glider.m_20197_().contains(target) && glider.isFlying() && glider.isNoEndimationPlaying() && (clusterPosPair = GliderEetleDropOffGoal.findLargestClusterAirAndGroundPositions(glider.m_9236_(), glider.m_20183_())) != null) {
            BlockPos pos = (BlockPos)clusterPosPair.getFirst();
            this.path = glider.m_21573_().m_7864_(pos, 0);
            this.searchBox = new AABB((BlockPos)clusterPosPair.getSecond()).m_82377_(4.0, 1.0, 4.0);
            this.clusterPos = Vec3.m_82512_((Vec3i)pos);
            return this.path != null;
        }
        return false;
    }

    public void m_8056_() {
        this.glider.m_21573_().m_26536_(this.path, 1.5);
    }

    public boolean m_8045_() {
        GliderEetle glider = this.glider;
        LivingEntity target = glider.m_5448_();
        if (target != null && target.m_6084_() && glider.m_20197_().contains(target) && glider.isFlying() && glider.m_21573_().m_26572_()) {
            if (glider.m_9236_().m_45976_(ChargerEetle.class, this.searchBox).size() < 3) {
                ++this.missingClusterTicks;
            }
            return this.missingClusterTicks < 10;
        }
        return false;
    }

    public void m_8041_() {
        this.glider.m_21573_().m_26573_();
        this.path = null;
        this.clusterPos = null;
        this.searchBox = null;
        this.missingClusterTicks = 0;
    }

    public void m_8037_() {
        AABB projectedBox;
        GliderEetle glider = this.glider;
        double distance = glider.m_20182_().m_82557_(this.clusterPos);
        LivingEntity attackTarget = glider.m_5448_();
        if (distance <= 2.25) {
            glider.makeGrounded();
            if (attackTarget instanceof IDataManager) {
                ((IDataManager)attackTarget).setValue(EEDataProcessors.CATCHING_COOLDOWN, (Object)(40 + glider.m_217043_().m_188503_(11)));
            }
        } else if (distance <= 20.25 && (projectedBox = GliderEetleDropOffGoal.getProjectedBoundingBox(glider)) != null && glider.m_9236_().m_45976_(ChargerEetle.class, projectedBox.m_82377_(1.0, 0.0, 1.0)).size() >= 4) {
            glider.makeGrounded();
            if (attackTarget instanceof IDataManager) {
                ((IDataManager)attackTarget).setValue(EEDataProcessors.CATCHING_COOLDOWN, (Object)(40 + glider.m_217043_().m_188503_(11)));
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    @Nullable
    private static AABB getProjectedBoundingBox(GliderEetle glider) {
        BlockPos.MutableBlockPos mutable = glider.m_20183_().m_122032_();
        int startY = mutable.m_123342_();
        Level world = glider.m_9236_();
        for (int y = 0; y <= 7; ++y) {
            mutable.m_142448_(startY - y);
            if (!world.m_46575_((BlockPos)mutable, (Entity)glider)) continue;
            AABB bb = glider.m_20191_();
            return bb.m_82386_(0.0, -(bb.f_82289_ - (double)mutable.m_123342_()), 0.0);
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPos, BlockPos> findLargestClusterAirAndGroundPositions(Level world, BlockPos origin) {
        BlockPos clusterPos = null;
        int largestCluster = 2;
        HashSet<ChargerEetle> foundInCluster = new HashSet<ChargerEetle>();
        List chargerEetleEntityList = world.m_6443_(ChargerEetle.class, new AABB(origin).m_82377_(24.0, 6.0, 24.0), Entity::m_20096_);
        ArrayList<Pair<Double, Double>> points = new ArrayList<Pair<Double, Double>>();
        for (ChargerEetle charger : chargerEetleEntityList) {
            if (foundInCluster.contains((Object)charger)) continue;
            int others = 0;
            for (ChargerEetle otherCharger : world.m_45976_(ChargerEetle.class, new AABB(charger.m_20183_()).m_82377_(4.0, 6.0, 4.0))) {
                foundInCluster.add(otherCharger);
                Vec3 pos = otherCharger.m_20182_();
                points.add((Pair<Double, Double>)Pair.of((Object)pos.f_82479_, (Object)pos.f_82481_));
                ++others;
            }
            if (others <= largestCluster) continue;
            Pair<Double, Double> centroidXZ = GliderEetleDropOffGoal.computeCentroid(points);
            points.clear();
            clusterPos = BlockPos.m_274561_((double)((Double)centroidXZ.getFirst()), (double)charger.m_20186_(), (double)((Double)centroidXZ.getSecond()));
        }
        if (clusterPos != null) {
            BlockPos.MutableBlockPos airPos = clusterPos.m_122032_();
            int startY = airPos.m_123342_();
            for (int y = 0; y <= 7; ++y) {
                airPos.m_142448_(startY + y);
                if (world.m_46859_((BlockPos)airPos)) continue;
                airPos.m_142448_(airPos.m_123342_() - 1);
                break;
            }
            return Pair.of((Object)airPos, clusterPos);
        }
        return null;
    }

    private static Pair<Double, Double> computeCentroid(List<Pair<Double, Double>> xzPoints) {
        double x = 0.0;
        double z = 0.0;
        for (Pair<Double, Double> pointXZ : xzPoints) {
            x += ((Double)pointXZ.getFirst()).doubleValue();
            z += ((Double)pointXZ.getSecond()).doubleValue();
        }
        double size = xzPoints.size();
        return Pair.of((Object)(x / size), (Object)(z / size));
    }
}

