/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block.poise;

import com.teamabnormals.endergetic.common.block.poise.GlowingPoiseStemBlock;
import com.teamabnormals.endergetic.common.block.poise.PoiseTallBushBlock;
import com.teamabnormals.endergetic.core.other.tags.EEBlockTags;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PoiseBushBlock
extends Block
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public PoiseBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.m_188501_() > 0.05f) {
            return;
        }
        double offsetX = GlowingPoiseStemBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
        double offsetZ = GlowingPoiseStemBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
        double x = (double)pos.m_123341_() + 0.5 + offsetX;
        double y = (double)pos.m_123342_() + 0.95 + (double)(rand.m_188501_() * 0.05f);
        double z = (double)pos.m_123343_() + 0.5 + offsetZ;
        worldIn.m_7106_((ParticleOptions)EEParticleTypes.SHORT_POISE_BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level p_220878_, RandomSource p_220879_, BlockPos p_220880_, BlockState p_220881_) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        PoiseTallBushBlock plant = (PoiseTallBushBlock)((Object)EEBlocks.TALL_POISE_BUSH.get());
        if (plant.m_49966_().m_60710_((LevelReader)level, pos) && level.m_46859_(pos.m_7494_())) {
            plant.placeAt((LevelAccessor)level, pos, 2);
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(EEBlockTags.POISE_PLANTABLE) || state.m_204336_(EEBlockTags.END_PLANTABLE);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.isValidGround(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }
}

