/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.blueprint.client.BlueprintRenderTypes;
import com.teamabnormals.endergetic.client.model.purpoid.PurpoidGelModel;
import com.teamabnormals.endergetic.client.model.purpoid.PurpoidModel;
import com.teamabnormals.endergetic.client.renderer.entity.layers.PurpoidEmissiveLayer;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.core.other.EEModelLayers;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PurpoidGelLayer
extends RenderLayer<Purpoid, PurpoidModel> {
    private final PurpoidGelModel[] gelModels;

    public PurpoidGelLayer(RenderLayerParent<Purpoid, PurpoidModel> parent, EntityModelSet entityModelSet) {
        super(parent);
        this.gelModels = new PurpoidGelModel[]{new PurpoidGelModel(entityModelSet.m_171103_(EEModelLayers.PURPOID_GEL)), new PurpoidGelModel(entityModelSet.m_171103_(EEModelLayers.PURP_GEL)), new PurpoidGelModel(entityModelSet.m_171103_(EEModelLayers.PURPAZOID_GEL))};
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Purpoid purpoid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int ordinal = purpoid.getSize().ordinal();
        PurpoidGelModel gelModel = this.gelModels[ordinal];
        gelModel.parentToHead(((PurpoidModel)this.m_117386_()).head);
        gelModel.setupAnim(purpoid, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        int overlay = LivingEntityRenderer.m_115338_((LivingEntity)purpoid, (float)0.0f);
        gelModel.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_117347_((Entity)purpoid))), packedLightIn, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        float alpha = 1.0f;
        int stunTimer = purpoid.getStunTimer();
        if (stunTimer > 0) {
            float stunTimerHalfCycles = (float)stunTimer / 20.0f;
            float progress = 1.0f - 2.0f * Mth.m_14154_((float)(stunTimerHalfCycles - (float)Mth.m_14143_((float)(stunTimerHalfCycles + 0.5f))));
            alpha = progress * progress;
        }
        gelModel.m_7695_(matrixStackIn, bufferIn.m_6299_(BlueprintRenderTypes.getUnshadedTranslucentEntity((ResourceLocation)PurpoidEmissiveLayer.TEXTURES[ordinal], (boolean)true)), 240, overlay, 1.0f, 1.0f, 1.0f, alpha);
    }

    public PurpoidGelModel getGelModel(int index) {
        return this.gelModels[index];
    }
}

