/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.api.entity.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;

public class EndergeticFlyingNodeProcessor
extends NodeEvaluator {
    public Node m_7171_() {
        return super.m_5676_(Mth.m_14107_((double)this.f_77313_.m_20191_().f_82288_), Mth.m_14107_((double)(this.f_77313_.m_20191_().f_82289_ + 0.5)), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82290_));
    }

    public Target m_7568_(double p_224768_1_, double p_224768_3_, double p_224768_5_) {
        return new Target(super.m_5676_(Mth.m_14107_((double)(p_224768_1_ - (double)(this.f_77313_.m_20205_() / 2.0f))), Mth.m_14107_((double)(p_224768_3_ + 0.5)), Mth.m_14107_((double)(p_224768_5_ - (double)(this.f_77313_.m_20205_() / 2.0f)))));
    }

    public int m_6065_(Node[] pathPoints, Node pathNode) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            Node pathpoint = this.getPoint(pathNode.f_77271_ + direction.m_122429_(), pathNode.f_77272_ + direction.m_122430_(), pathNode.f_77273_ + direction.m_122431_());
            if (pathpoint == null || pathpoint.f_77279_) continue;
            pathPoints[i++] = pathpoint;
        }
        return i;
    }

    public BlockPathTypes m_7209_(BlockGetter blockaccessIn, int x, int y, int z, Mob entitylivingIn) {
        return this.m_8086_(blockaccessIn, x, y, z);
    }

    public BlockPathTypes m_8086_(BlockGetter blockaccessIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = blockaccessIn.m_8055_(blockpos);
        return blockstate.m_60647_(blockaccessIn, blockpos, PathComputationType.AIR) ? BlockPathTypes.WALKABLE : BlockPathTypes.BLOCKED;
    }

    @Nullable
    private Node getPoint(int x, int y, int z) {
        BlockPathTypes pathnodetype = this.isFree(x, y, z);
        return pathnodetype != BlockPathTypes.BREACH && pathnodetype != BlockPathTypes.WALKABLE ? null : this.m_5676_(x, y, z);
    }

    protected Node m_5676_(int x, int y, int z) {
        Node pathpoint = null;
        BlockPathTypes pathnodetype = this.m_8086_((BlockGetter)this.f_77313_.m_9236_(), x, y, z);
        float malus = this.f_77313_.m_21439_(pathnodetype);
        if (malus >= 0.0f) {
            pathpoint = super.m_5676_(x, y, z);
            pathpoint.f_77282_ = pathnodetype;
            pathpoint.f_77281_ = Math.max(pathpoint.f_77281_, malus);
            if (this.f_77312_.m_6425_(new BlockPos(x, y, z)).m_76178_()) {
                pathpoint.f_77281_ += 8.0f;
            }
        }
        return pathpoint;
    }

    private BlockPathTypes isFree(int x, int y, int z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = x; i < x + this.f_77315_; ++i) {
            for (int j = y; j < y + this.f_77316_; ++j) {
                for (int k = z; k < z + this.f_77317_; ++k) {
                    FluidState ifluidstate = this.f_77312_.m_6425_((BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k));
                    BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k));
                    if (ifluidstate.m_76178_() && blockstate.m_60647_((BlockGetter)this.f_77312_, blockpos$mutableblockpos.m_7495_(), PathComputationType.AIR) && blockstate.m_60795_()) {
                        return BlockPathTypes.WALKABLE;
                    }
                    if (!ifluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.BLOCKED;
                }
            }
        }
        BlockState blockstate1 = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos);
        if (blockstate1.m_60647_((BlockGetter)this.f_77312_, (BlockPos)blockpos$mutableblockpos, PathComputationType.AIR)) {
            return BlockPathTypes.WALKABLE;
        }
        return BlockPathTypes.BLOCKED;
    }
}

