/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.pyzpre.createbitterballen.block.mechanicalfryer.MechanicalFryer;
import com.pyzpre.createbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import com.pyzpre.createbitterballen.index.PartialsRegistry;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FryerInstance
extends ShaftVisual<MechanicalFryerEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance fryerHead;
    private final OrientedInstance fryerPole;
    private final MechanicalFryerEntity fryer;

    public FryerInstance(VisualizationContext context, MechanicalFryerEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.fryer = blockEntity;
        this.fryerHead = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)PartialsRegistry.MECHANICAL_FRYER_HEAD)).createInstance();
        this.fryerPole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE)).createInstance();
        this.transformModels(partialTick);
    }

    private void transformModels(float pt) {
        float renderedHeadOffset = this.getRenderedHeadOffset(pt);
        Direction facing = (Direction)this.blockState.m_61143_(MechanicalFryer.HORIZONTAL_FACING);
        Quaternionf rotation = this.getQuaternionForFacing(facing);
        this.fryerHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
        this.fryerPole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).rotation((Quaternionfc)rotation).setChanged();
    }

    private Quaternionf getQuaternionForFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Quaternionf().rotateY(0.0f);
            }
            case SOUTH: {
                return new Quaternionf().rotateY((float)Math.PI);
            }
            case WEST: {
                return new Quaternionf().rotateY(1.5707964f);
            }
            case EAST: {
                return new Quaternionf().rotateY(-1.5707964f);
            }
        }
        return new Quaternionf();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    private float getRenderedHeadOffset(float pt) {
        return this.fryer.getRenderedHeadOffset(pt);
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.pos.m_7495_(), new FlatLit[]{this.fryerHead});
        this.relight(this.pos, new FlatLit[]{this.fryerPole});
    }

    protected void _delete() {
        super._delete();
        this.fryerHead.delete();
        this.fryerPole.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.fryerHead);
        consumer.accept((Instance)this.fryerPole);
    }
}

