/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MathsHelper {
    public static double angleBetween(Vec3 vec1, Vec3 vec2, Vec3 plane) {
        double angle = Math.acos(vec1.m_82526_(vec2) / (vec1.m_82553_() * vec2.m_82553_())) * 180.0 / 3.1415927410125732;
        if (vec1.m_82526_(vec2.m_82537_(plane)) < 0.0) {
            angle = 360.0 - angle;
        }
        return angle;
    }

    public static Vec3 rotate(Vec3 vec, Vec3 rotationAxis, double angle) {
        Vec3 k = rotationAxis.m_82541_();
        double angleInRads = angle * 3.1415927410125732 / 180.0;
        return vec.m_82490_(Math.cos(angleInRads)).m_82549_(k.m_82537_(vec).m_82490_(Math.sin(angleInRads))).m_82549_(k.m_82490_(k.m_82526_(vec) * (1.0 - Math.cos(angleInRads))));
    }

    public static Vec3i add(Vec3i vec1, Vec3i vec2) {
        return new Vec3i(vec1.m_123341_() + vec2.m_123341_(), vec1.m_123342_() + vec2.m_123342_(), vec1.m_123343_() + vec2.m_123343_());
    }

    public static Comparator<Vec3> getClosest(Vec3 targetVector) {
        return (v1, v2) -> Double.compare(v1.m_82526_(targetVector), v2.m_82526_(targetVector));
    }

    public static double azimuth(Vec3 vec) {
        return Math.atan2(vec.f_82479_, vec.f_82481_);
    }

    public static double inclination(Vec3 vec) {
        return Math.atan2(Math.sqrt(vec.m_7096_() * vec.m_7096_() + vec.m_7094_() * vec.m_7094_()), vec.m_7098_());
    }

    public static AABB expandToInclude(AABB box, Vec3 point) {
        return new AABB(Math.min(box.f_82288_, point.f_82479_), Math.min(box.f_82289_, point.f_82480_), Math.min(box.f_82290_, point.f_82481_), Math.max(box.f_82291_, point.f_82479_), Math.max(box.f_82292_, point.f_82480_), Math.max(box.f_82293_, point.f_82481_));
    }

    public static AABB expandToInclude(AABB box, BlockPos pos) {
        return MathsHelper.expandToInclude(MathsHelper.expandToInclude(box, Vec3.m_82528_((Vec3i)pos)), Vec3.m_82528_((Vec3i)pos).m_82520_(1.0, 1.0, 1.0));
    }

    public static double volume(AABB box) {
        return (box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_);
    }
}

