/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team.packet;

import com.petrolpark.team.ITeam;
import com.petrolpark.team.ITeamBoundBlockEntity;
import com.petrolpark.team.packet.BindTeamPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkEvent;

public class BindTeamBlockPacket
extends BindTeamPacket {
    public final BlockHitResult hit;

    public BindTeamPacket.Factory forHit(BlockHitResult hit) {
        return new Factory(hit);
    }

    public <T extends ITeam<? super T>> BindTeamBlockPacket(T team, BlockHitResult hit) {
        super(team);
        this.hit = hit;
    }

    public BindTeamBlockPacket(FriendlyByteBuf buffer) {
        super(buffer);
        this.hit = buffer.m_130283_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.m_130062_(this.hit);
    }

    @Override
    public <T extends ITeam<? super T>> void handle(T team, NetworkEvent.Context context) {
        BlockEntity be = context.getSender().m_9236_().m_7702_(this.hit.m_82425_());
        if (be instanceof ITeamBoundBlockEntity) {
            ITeamBoundBlockEntity tbbe = (ITeamBoundBlockEntity)be;
            tbbe.bind(team, (Player)context.getSender(), this.hit);
        }
    }

    private static class Factory
    implements BindTeamPacket.Factory {
        public final BlockHitResult hit;

        public Factory(BlockHitResult hit) {
            this.hit = hit;
        }

        @Override
        public <T extends ITeam<? super T>> BindTeamPacket create(T team) {
            return new BindTeamBlockPacket(team, this.hit);
        }
    }
}

