/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team;

import com.petrolpark.team.AbstractTeam;
import com.petrolpark.team.ITeam;
import com.petrolpark.team.TeamTypes;
import com.petrolpark.team.data.ITeamDataType;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterCapability
public class SinglePlayerTeam
extends AbstractTeam<SinglePlayerTeam>
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<SinglePlayerTeam> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<SinglePlayerTeam>(){});
    public final Player player;

    public SinglePlayerTeam(Player player) {
        this.player = player;
    }

    @Override
    public ITeam.ITeamType<SinglePlayerTeam> getType() {
        return (ITeam.ITeamType)TeamTypes.SINGLE_PLAYER.get();
    }

    @Override
    public boolean isMember(Player player) {
        return player.equals((Object)this.player);
    }

    @Override
    public Stream<String> streamMemberUsernames(Level level) {
        return Stream.of(this.player.m_36316_().getName());
    }

    @Override
    public boolean isAdmin(Player player) {
        return true;
    }

    @Override
    public Component getName(Level level) {
        return this.player.m_5446_();
    }

    @Override
    public void setChanged(Level level, ITeamDataType<?> dataType) {
    }

    @Override
    public void renderIcon(GuiGraphics graphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.player == null) {
            return;
        }
        PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)mc.m_91109_().m_240306_(this.player.m_36316_()), (int)0, (int)0, (int)16);
    }

    @Override
    public Component getRenderedMemberList(int maxTextWidth) {
        return this.player.m_5446_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.saveTeamData(this.player.m_9236_());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.loadTeamData(this.player.m_9236_(), nbt);
    }

    public static class Type
    implements ITeam.ITeamType<SinglePlayerTeam> {
        @Override
        public SinglePlayerTeam read(CompoundTag tag, Level level) {
            UUID uuid = tag.m_128342_("Player");
            Player player = level.m_46003_(uuid);
            if (player != null) {
                return (SinglePlayerTeam)player.getCapability(CAPABILITY).resolve().get();
            }
            return null;
        }

        @Override
        public void write(SinglePlayerTeam team, CompoundTag tag) {
            tag.m_128362_("Player", team.player.m_20148_());
        }
    }
}

