/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.fluid;

import com.petrolpark.contamination.FluidContamination;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidMixer {
    protected static final Set<IFluidMixer> MIXERS = new HashSet<IFluidMixer>();

    public static void register(IFluidMixer mixer) {
        MIXERS.add(mixer);
    }

    public static Optional<FluidStack> mix(int maxResultAmount, FluidStack ... fluidStacks) {
        if (fluidStacks.length <= 1) {
            return Optional.empty();
        }
        IFluidMixer currentMixer = null;
        int currentPriority = 0;
        ArrayList<IFluidMixer> afterMixers = new ArrayList<IFluidMixer>(MIXERS.size());
        for (IFluidMixer mixer : MIXERS) {
            int priority = mixer.getMixPriority(fluidStacks);
            if (priority >= 0) {
                afterMixers.add(mixer);
            }
            if (priority <= currentPriority) continue;
            currentPriority = priority;
            currentMixer = mixer;
        }
        if (currentMixer == null) {
            return Optional.empty();
        }
        FluidStack result = currentMixer.mix(fluidStacks);
        for (IFluidMixer mixer : afterMixers) {
            mixer.afterMix(result, fluidStacks);
        }
        return Optional.of(result);
    }

    public static FluidStack mixIn(FluidStack baseFluidStack, FluidStack addedFluidStack, int maxResultAmount, IFluidHandler.FluidAction action) {
        if (baseFluidStack.isEmpty()) {
            addedFluidStack.setAmount(Math.min(addedFluidStack.getAmount(), maxResultAmount));
            return addedFluidStack.copy();
        }
        if (addedFluidStack.isEmpty()) {
            return baseFluidStack;
        }
        IFluidMixer currentMixer = null;
        int currentPriority = 0;
        ArrayList<IFluidMixer> afterMixers = new ArrayList<IFluidMixer>(MIXERS.size());
        for (IFluidMixer mixer : MIXERS) {
            int priority = mixer.getMix2Priority(baseFluidStack, addedFluidStack);
            if (priority >= 0) {
                afterMixers.add(mixer);
            }
            if (priority <= currentPriority) continue;
            currentPriority = priority;
            currentMixer = mixer;
        }
        if (currentMixer != null) {
            addedFluidStack.setAmount(currentMixer.getAmountToMixIn(maxResultAmount, baseFluidStack, addedFluidStack));
            FluidStack result = currentMixer.mix2(baseFluidStack, addedFluidStack);
            if (afterMixers.isEmpty() || action.simulate()) {
                return result;
            }
            FluidStack[] fluidStacks = new FluidStack[]{baseFluidStack, addedFluidStack};
            for (IFluidMixer mixer : afterMixers) {
                mixer.afterMix(result, fluidStacks);
            }
            return result;
        }
        addedFluidStack.setAmount(0);
        return baseFluidStack;
    }

    static {
        FluidMixer.register(FluidContamination.MIXER);
    }

    public static interface IFluidMixer {
        default public int getAmountToMixIn(int maxResultAmount, FluidStack baseFluidStack, FluidStack addedFluidStack) {
            return Math.min(addedFluidStack.getAmount(), Math.max(0, maxResultAmount - baseFluidStack.getAmount()));
        }

        default public int getMix2Priority(FluidStack fluidStack1, FluidStack fluidStack2) {
            return this.getMixPriority(fluidStack1, fluidStack2);
        }

        public int getMixPriority(FluidStack ... var1);

        default public FluidStack mix2(FluidStack fluidStack1, FluidStack fluidStack2) {
            return this.mix(fluidStack1, fluidStack2);
        }

        public FluidStack mix(FluidStack ... var1);

        public void afterMix(FluidStack var1, FluidStack ... var2);
    }
}

