/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat;

import com.petrolpark.registrate.PetrolparkRegistrate;
import com.petrolpark.util.Lang;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public enum CompatMods {
    CREATE,
    ACADEMY,
    CHOO_CHOO_TRADE("choochootrade"),
    CREATE_BISTRO("createbistro"),
    DESTROY,
    PETROLS_PARTS("petrolsparts"),
    PQUALITY,
    BIG_CANNONS("createbigcannons"),
    CURIOS,
    JEI,
    TFMG;

    public final String id;
    private PetrolparkRegistrate registrate;

    private CompatMods() {
        this.id = Lang.asId(this.name());
    }

    private CompatMods(String id) {
        this.id = id;
    }

    public static boolean isLoading(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    public boolean isLoading() {
        return CompatMods.isLoading(this.id);
    }

    public boolean isLoaded() {
        return ModList.get().isLoaded(this.id);
    }

    public void executeIfInstalled(Supplier<Runnable> toExecute) {
        if (this.isLoaded()) {
            toExecute.get().run();
        }
    }

    public ResourceLocation asResource(String path) {
        return new ResourceLocation(this.id, path);
    }

    public PetrolparkRegistrate registrate() {
        if (this.registrate == null) {
            this.registrate = new PetrolparkRegistrate(this.id);
        }
        return this.registrate;
    }
}

