/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.config;

import com.epherical.epherolib.config.CommonConfig;
import com.epherical.epherolib.libs.org.spongepowered.configurate.CommentedConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.ConfigurateException;
import com.epherical.epherolib.libs.org.spongepowered.configurate.ConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.SerializationException;
import com.epherical.serverbrowser.config.OfficialServer;
import java.util.ArrayList;
import java.util.List;

public class SBConfig
extends CommonConfig {
    public boolean serverBrowserNotification = false;
    public String bisectPackID = "";
    public String modPackFilter = "";
    public List<OfficialServer> officialServers = new ArrayList<OfficialServer>();
    public List<String> blacklistedServers = new ArrayList<String>();

    public SBConfig(AbstractConfigurationLoader.Builder<?, ?> loaderBuilder, String configName) {
        super(loaderBuilder, configName);
    }

    public void parseConfig(CommentedConfigurationNode node) {
        this.serverBrowserNotification = ((CommentedConfigurationNode)node.node(new Object[]{"serverBrowserNotification"})).getBoolean(this.serverBrowserNotification);
        this.bisectPackID = ((CommentedConfigurationNode)node.node(new Object[]{"bisectPackID"})).getString(this.bisectPackID);
        this.modPackFilter = ((CommentedConfigurationNode)node.node(new Object[]{"modPackFilter"})).getString(this.modPackFilter);
        try {
            this.officialServers = ((CommentedConfigurationNode)node.node(new Object[]{"officialServers"})).getList(OfficialServer.class, this.officialServers);
            this.blacklistedServers = ((CommentedConfigurationNode)node.node(new Object[]{"blacklistedServers"})).getList(String.class, new ArrayList());
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public CommentedConfigurationNode generateConfig(CommentedConfigurationNode node) {
        try {
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"serverBrowserNotification"})).set((Object)this.serverBrowserNotification)).comment("Will determine if the user receives a 'notification' that they can explore the server browser.");
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"bisectPackID"})).set((Object)this.bisectPackID)).comment("If you want bisect servers to appear in the server listing");
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"modPackFilter"})).set((Object)this.modPackFilter)).comment("If you have a modpack tag on the minecraft.multiplayerservers.net website you can put the name of the tag in here and it will filter out all other servers");
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"blacklistedServers"})).setList(String.class, this.blacklistedServers)).comment("If you don't want certain servers to appear on the list (excluding bisect) put the IP of it in here.");
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"officialServers"})).setList(OfficialServer.class, this.officialServers)).comment("If you have an official server for you pack, you can put it in here and it will appear at the top of the list");
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return node;
    }

    public void saveConfig() {
        try {
            this.loader.save((ConfigurationNode)this.generateConfig((CommentedConfigurationNode)this.rootNode));
        }
        catch (ConfigurateException e) {
            throw new RuntimeException(e);
        }
    }
}

