/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import dev.wuffs.bcc.CommonClass;
import dev.wuffs.bcc.contract.ServerDataExtension;
import dev.wuffs.bcc.data.BetterStatus;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import org.slf4j.Logger;

public class ServerPinger {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component CANT_CONNECT_MESSAGE = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130938_(style -> style.m_178520_(-65536));
    private final List<Connection> connections = Collections.synchronizedList(Lists.newArrayList());

    public void pingServer(final ServerData data, final Runnable runnable, final AtomicBoolean atomicBoolean) throws UnknownHostException {
        ServerAddress serverAddress = ServerAddress.m_171864_((String)data.f_105363_);
        Optional<InetSocketAddress> optionalINet = ServerNameResolver.f_171881_.m_171890_(serverAddress).map(ResolvedServerAddress::m_142641_);
        if (!optionalINet.isPresent()) {
            atomicBoolean.set(false);
            this.onPingFailed(ConnectScreen.f_169260_, data);
        } else {
            InetSocketAddress socketAddress = optionalINet.get();
            final Connection connection = Connection.m_178300_((InetSocketAddress)socketAddress, (boolean)false);
            this.connections.add(connection);
            data.f_105365_ = Component.m_237115_((String)"multiplayer.status.pinging");
            data.f_105366_ = -1L;
            data.f_105370_ = Collections.emptyList();
            connection.m_129505_((PacketListener)new ClientStatusPacketListener(){
                private boolean success;
                private boolean receivedPing;
                private long pingStart;

                public void m_6440_(ClientboundStatusResponsePacket responsePacket) {
                    if (this.receivedPing) {
                        connection.m_129507_((Component)Component.m_237115_((String)"multiplayer.status.unrequested"));
                        atomicBoolean.set(false);
                    } else {
                        this.receivedPing = true;
                        ServerStatus serverStatus = responsePacket.f_134886_();
                        data.f_105365_ = serverStatus.f_134900_();
                        BetterStatus betterData = ((ServerDataExtension)responsePacket.f_134886_()).getBetterData();
                        if (betterData == null || !CommonClass.comparePingData((BetterStatus)betterData)) {
                            atomicBoolean.set(false);
                        }
                        ((ServerDataExtension)data).setBetterData(betterData);
                        serverStatus.f_134902_().ifPresentOrElse(version -> {
                            data2.f_105368_ = Component.m_237113_((String)version.f_134962_());
                            data2.f_105367_ = version.f_134963_();
                        }, () -> {
                            data2.f_105368_ = Component.m_237115_((String)"multiplayer.status.old");
                            data2.f_105367_ = 0;
                        });
                        serverStatus.f_134901_().ifPresentOrElse(players -> {
                            data2.f_105364_ = ServerPinger.formatPlayerCount(players.f_271178_(), players.f_271503_());
                            data2.f_263840_ = players;
                            if (!players.f_134919_().isEmpty()) {
                                ArrayList<MutableComponent> messages = new ArrayList<MutableComponent>(players.f_134919_().size());
                                for (GameProfile profile : players.f_134919_()) {
                                    messages.add(Component.m_237113_((String)profile.getName()));
                                }
                                if (players.f_134919_().size() < players.f_271178_()) {
                                    messages.add(Component.m_237110_((String)"multiplayer.status.and_more", (Object[])new Object[]{players.f_271178_() - players.f_134919_().size()}));
                                }
                                data2.f_105370_ = messages;
                            } else {
                                data2.f_105370_ = List.of();
                            }
                        }, () -> {
                            data2.f_105364_ = Component.m_237115_((String)"multiplayer.status.unknown").m_130940_(ChatFormatting.DARK_GRAY);
                        });
                        serverStatus.f_134903_().ifPresent($$2 -> {
                            if (!Arrays.equals($$2.f_271462_(), data.m_271916_())) {
                                data.m_271813_($$2.f_271462_());
                                runnable.run();
                            }
                        });
                        this.pingStart = Util.m_137550_();
                        connection.m_129512_((Packet)new ServerboundPingRequestPacket(this.pingStart));
                        this.success = true;
                    }
                }

                public void m_7017_(ClientboundPongResponsePacket response) {
                    long start = this.pingStart;
                    long current = Util.m_137550_();
                    data.f_105366_ = current - start;
                    connection.m_129507_((Component)Component.m_237115_((String)"multiplayer.status.finished"));
                }

                public void m_7026_(Component message) {
                    if (!this.success) {
                        atomicBoolean.set(false);
                        ServerPinger.this.onPingFailed(message, data);
                    }
                }

                public boolean m_6198_() {
                    atomicBoolean.set(connection.m_129536_());
                    return connection.m_129536_();
                }
            });
            try {
                System.out.print("");
                connection.m_129512_((Packet)new ClientIntentionPacket(serverAddress.m_171863_(), serverAddress.m_171866_(), ConnectionProtocol.STATUS));
                connection.m_129512_((Packet)new ServerboundStatusRequestPacket());
            }
            catch (Throwable error) {
                atomicBoolean.set(false);
                LOGGER.error("Failed to ping server {}", (Object)data, (Object)error);
            }
        }
    }

    static Component formatPlayerCount(int $$0, int $$1) {
        return Component.m_237113_((String)Integer.toString($$0)).m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.DARK_GRAY)).m_130946_(Integer.toString($$1)).m_130940_(ChatFormatting.GRAY);
    }

    public void onPingFailed(Component message, ServerData server) {
        LOGGER.error("Can't ping {}: {}", (Object)server.f_105363_, (Object)message.getString());
        server.f_105365_ = CANT_CONNECT_MESSAGE;
        server.f_105364_ = CommonComponents.f_237098_;
    }
}

