/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpackscreateintegration.init;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.KeybindHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.backpack.MountedSubBackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.client.MountedBackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.client.MountedBackpackSettingsScreen;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common.MountedBackpackContainerMenu;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.compat.trashslot.TrashSlotScreenRegistry;

public class ModContentClient {
    public static void registerHandlers(IEventBus modBus) {
        modBus.addListener(ModContentClient::onMenuScreenRegister);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(EventPriority.HIGH, ModContentClient::handleGuiMouseKeyPress);
        eventBus.addListener(EventPriority.HIGH, ModContentClient::handleGuiKeyPress);
    }

    private static void onMenuScreenRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.Keys.MENU_TYPES)) {
            return;
        }
        MenuScreens.m_96206_(ModContent.MOUNTED_BACKPACK_CONTAINER_TYPE.get(), MountedBackpackScreen::constructScreen);
        MenuScreens.m_96206_(ModContent.MOUNTED_BACKPACK_SETTINGS_CONTAINER_TYPE.get(), MountedBackpackSettingsScreen::constructScreen);
        TrashSlotScreenRegistry.registerScreen(MountedBackpackScreen.class);
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        InputConstants.Key key = InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode());
        if (KeybindHandler.BACKPACK_OPEN_KEYBIND.isActiveAndMatches(key) && ModContentClient.sendBackpackOpenOrCloseMessage()) {
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(event.getButton());
        if (KeybindHandler.BACKPACK_OPEN_KEYBIND.isActiveAndMatches(input) && ModContentClient.sendBackpackOpenOrCloseMessage()) {
            event.setCanceled(true);
        }
    }

    private static boolean tryCallSort(Screen gui) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (abstractContainerMenu = mc.f_91074_.f_36096_) instanceof MountedBackpackContainerMenu) {
            double mouseY;
            MouseHandler mh;
            double mouseX;
            MountedBackpackScreen screen;
            Slot selectedSlot;
            MountedBackpackContainerMenu container = (MountedBackpackContainerMenu)abstractContainerMenu;
            if (gui instanceof MountedBackpackScreen && ((selectedSlot = (screen = (MountedBackpackScreen)gui).m_97744_(mouseX = (mh = mc.f_91067_).m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_(), mouseY = mh.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_())) == null || container.isNotPlayersInventorySlot(selectedSlot.f_40219_))) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static boolean sendBackpackOpenOrCloseMessage() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof MountedBackpackScreen) {
            MountedBackpackScreen mountedBackpackScreen = (MountedBackpackScreen)screen;
            Slot slot = mountedBackpackScreen.getSlotUnderMouse();
            if (((MountedBackpackContainerMenu)mountedBackpackScreen.m_6262_()).isFirstLevelStorage() && slot instanceof StorageInventorySlot && slot.m_7993_().m_41720_() instanceof BackpackItem && slot.m_7993_().m_41613_() == 1) {
                ((MountedBackpackContainerMenu)mountedBackpackScreen.m_6262_()).getContext().getSubBackpackContext(slot.f_40219_);
                SBPPacketHandler.INSTANCE.sendToServer((Object)new MountedSubBackpackOpenMessage(slot.f_40219_));
                return true;
            }
        }
        return false;
    }
}

