/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.ClientServices;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.ITagHelper;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.darkhax.tipsmod.impl.resources.ConditionRules;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;

public class SimpleTip
implements ITip {
    public static final ITipSerializer<SimpleTip> SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final Component title;
    private final Component text;
    private final Optional<Integer> cycleTime;
    private final ConditionRules<Screen> screens;
    private final ConditionRules<Holder<Biome>> biome;
    private final ConditionRules<Holder<DimensionType>> dimension;
    private final ConditionRules<Set<ResourceLocation>> advancements;
    private final boolean hasScreenConditions;
    private final boolean hasBiomeConditions;
    private final boolean hasDimensionConditions;
    private final boolean hasAdvancementConditions;
    private final boolean requiresPlayerContext;

    public SimpleTip(ResourceLocation id, Component title, Component text, Optional<Integer> cycleTime) {
        this(id, title, text, cycleTime, null, null, null, null);
    }

    public SimpleTip(ResourceLocation id, Component title, Component text, Optional<Integer> cycleTime, ConditionRules<Screen> screens, ConditionRules<Holder<Biome>> biomes, ConditionRules<Holder<DimensionType>> dimension, ConditionRules<Set<ResourceLocation>> advancements) {
        this.id = id;
        this.title = title;
        this.text = text;
        this.cycleTime = cycleTime;
        this.screens = screens;
        this.biome = biomes;
        this.dimension = dimension;
        this.advancements = advancements;
        this.hasScreenConditions = this.screens != null && !this.screens.isEmpty();
        this.hasBiomeConditions = this.biome != null && !this.biome.isEmpty();
        this.hasDimensionConditions = this.dimension != null && !this.dimension.isEmpty();
        this.hasAdvancementConditions = this.advancements != null && !this.advancements.isEmpty();
        this.requiresPlayerContext = this.hasBiomeConditions || this.hasDimensionConditions || this.hasAdvancementConditions;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public Component getText() {
        return this.text;
    }

    @Override
    public int getCycleTime() {
        return this.cycleTime.orElse(TipsModCommon.CONFIG.defaultCycleTime);
    }

    @Override
    public boolean canDisplayOnScreen(Screen screen) {
        if (this.hasScreenConditions ? this.screens.test(screen) : TipsAPI.canRenderOnScreen(screen)) {
            if (this.requiresPlayerContext) {
                CachedSupplier completedAdvancements;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return false;
                }
                if (this.hasBiomeConditions && !this.biome.test((Holder<Biome>)player.m_9236_().m_204166_(player.m_20183_()))) {
                    return false;
                }
                if (this.hasDimensionConditions && !this.dimension.test((Holder<DimensionType>)player.m_9236_().m_204156_())) {
                    return false;
                }
                if (this.hasAdvancementConditions && !this.advancements.test((Set)(completedAdvancements = CachedSupplier.cache(() -> ClientServices.CLIENT.getCompletedAdvancements(player).stream().map(Advancement::m_138327_).collect(Collectors.toSet()))).get())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static final class Serializer
    implements ITipSerializer<SimpleTip> {
        private Serializer() {
        }

        @Override
        public SimpleTip fromJSON(ResourceLocation id, JsonObject json) {
            Component title = (Component)Serializers.TEXT.fromJSON(json, "title", (Object)TipsModCommon.CONFIG.defaultTitle);
            Component text = (Component)Serializers.TEXT.fromJSON(json, "tip");
            Optional cycleTime = Serializers.INT.fromJSONOptional(json, "cycleTime");
            if (title == null) {
                throw new JsonParseException("Tip " + id.toString() + " does not have a title. This is required!");
            }
            if (text == null) {
                throw new JsonParseException("Tip " + id.toString() + " does not have text. This is required.");
            }
            JsonObject conditions = json.getAsJsonObject("conditions");
            if (conditions != null) {
                ConditionRules<Screen> screenRules = ConditionRules.fromElement(ConditionRules::screenRuleBuilder, conditions.get("screens"));
                ConditionRules<Holder<Biome>> biomeRules = ConditionRules.fromElement(rule -> ConditionRules.registryRuleBuilder(arg_0 -> ((ITagHelper)Services.TAGS).biomeTag(arg_0), rule), conditions.get("biomes"));
                ConditionRules<Holder<DimensionType>> dimensionRules = ConditionRules.fromElement(rule -> ConditionRules.registryRuleBuilder(arg_0 -> ((ITagHelper)Services.TAGS).dimensionTypeTag(arg_0), rule), conditions.get("dimensions"));
                ConditionRules<Set<ResourceLocation>> advancements = ConditionRules.fromElement(ConditionRules::resourceLocationsRuleBuilder, conditions.get("advancements"));
                return new SimpleTip(id, title, text, cycleTime, screenRules, biomeRules, dimensionRules, advancements);
            }
            return new SimpleTip(id, title, text, cycleTime);
        }

        @Override
        public JsonObject toJSON(SimpleTip toWrite) {
            JsonObject json = new JsonObject();
            Serializers.RESOURCE_LOCATION.toJSON(json, "type", (Object)TipsAPI.DEFAULT_SERIALIZER);
            Serializers.TEXT.toJSON(json, "title", (Object)toWrite.title);
            Serializers.TEXT.toJSON(json, "tip", (Object)toWrite.text);
            Serializers.INT.toJSONOptional(json, "cycleTime", toWrite.cycleTime);
            JsonObject conditions = new JsonObject();
            if (toWrite.screens != null && !toWrite.screens.isEmpty()) {
                conditions.add("screens", toWrite.screens.writeJson());
            }
            if (toWrite.biome != null && !toWrite.biome.isEmpty()) {
                conditions.add("biomes", toWrite.biome.writeJson());
            }
            if (toWrite.dimension != null && !toWrite.dimension.isEmpty()) {
                conditions.add("dimensions", toWrite.dimension.writeJson());
            }
            if (toWrite.advancements != null && !toWrite.advancements.isEmpty()) {
                conditions.add("advancements", toWrite.advancements.writeJson());
            }
            if (!conditions.keySet().isEmpty()) {
                json.add("conditions", (JsonElement)conditions);
            }
            return json;
        }
    }
}

