/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Constants;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.darkhax.tipsmod.impl.resources.SimpleTip;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class TipsAPI {
    public static final ResourceLocation DEFAULT_SERIALIZER = new ResourceLocation("tips", "simple_tip");
    public static final Component DEFAULT_TITLE = Component.m_237115_((String)"tipsmod.title.default").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE, ChatFormatting.YELLOW});
    private static final Map<ResourceLocation, ITipSerializer<?>> SERIALIZERS = new HashMap();
    private static final Set<Class<? extends Screen>> SCREENS = new HashSet<Class<? extends Screen>>();
    private static int currentTipIndex = 0;
    @Deprecated
    public static final ITip EMPTY = new SimpleTip(new ResourceLocation("bookshelf", "empty"), DEFAULT_TITLE, (Component)Component.m_237113_((String)"This is deprecated and should no longer be used."), Optional.of(0));

    public static void registerTipSerializer(ResourceLocation id, ITipSerializer<?> serializer) {
        SERIALIZERS.put(id, serializer);
    }

    public static void registerTipScreen(Class<? extends Screen> screenClass) {
        SCREENS.add(screenClass);
    }

    public static boolean canRenderOnScreen(Screen screen) {
        return SCREENS.stream().anyMatch(clazz -> clazz.isInstance(screen));
    }

    @Nullable
    @Deprecated
    public static ITip getRandomTip() {
        return TipsAPI.getRandomTip(Minecraft.m_91087_().f_91080_);
    }

    @Nullable
    public static ITip getRandomTip(Screen screen) {
        List<ITip> filteredTips = TipsAPI.getLoadedTips().stream().filter(tip -> TipsAPI.canDisplayTip(tip) && tip.canDisplayOnScreen(screen)).toList();
        if (currentTipIndex + 1 > filteredTips.size()) {
            currentTipIndex = 0;
        }
        if (!filteredTips.isEmpty()) {
            return filteredTips.get(currentTipIndex++);
        }
        return null;
    }

    public static ITipSerializer<?> getTipSerializer(ResourceLocation id) {
        return SERIALIZERS.get(id);
    }

    public static List<ITip> getLoadedTips() {
        return TipsModCommon.TIP_MANAGER.getTips();
    }

    public static boolean canDisplayTip(ITip tip) {
        TranslatableContents translatable;
        ComponentContents componentContents;
        if (tip == null) {
            return false;
        }
        if (tip.getId() == null) {
            Constants.LOG.error("Found invalid tip without an ID. Object: {}, Class: {}", (Object)tip, tip.getClass());
            return false;
        }
        if (tip.getTitle() == null) {
            Constants.LOG.error("Found invalid tip. Title is null. Object: {}, Class: {}, ID: {}", new Object[]{tip, tip.getClass(), tip.getId()});
            return false;
        }
        if (tip.getText() == null) {
            Constants.LOG.error("Found invalid tip. Text is null. Object: {}, Class: {}, ID: {}", new Object[]{tip, tip.getClass(), tip.getId()});
            return false;
        }
        ResourceLocation id = tip.getId();
        if (TipsModCommon.CONFIG.ignoredNamespaces.contains(id.m_135827_())) {
            return false;
        }
        if (TipsModCommon.CONFIG.ignoredTips.contains(id.toString())) {
            return false;
        }
        return !TipsModCommon.CONFIG.hideUnlocalizedTips || !((componentContents = tip.getText().m_214077_()) instanceof TranslatableContents) || I18n.m_118936_((String)(translatable = (TranslatableContents)componentContents).m_237508_());
    }
}

