/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item.block_placer;

import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.hail.create_fantasizing.item.block_placer.BPBrush;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerTools;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class BPDynamicBrush
extends BPBrush {
    public static final int MAX_RADIUS = 10;
    private boolean surface;

    public BPDynamicBrush(boolean surface) {
        super(1);
        this.surface = surface;
    }

    @Override
    Component getParamLabel(int paramIndex) {
        return CreateLang.translateDirect((String)"generic.range", (Object[])new Object[0]);
    }

    @Override
    public BlockPlacerTools[] getSupportedTools() {
        BlockPlacerTools[] blockPlacerToolsArray;
        if (this.surface) {
            BlockPlacerTools[] blockPlacerToolsArray2 = new BlockPlacerTools[3];
            blockPlacerToolsArray2[0] = BlockPlacerTools.Overlay;
            blockPlacerToolsArray2[1] = BlockPlacerTools.Replace;
            blockPlacerToolsArray = blockPlacerToolsArray2;
            blockPlacerToolsArray2[2] = BlockPlacerTools.Clear;
        } else {
            BlockPlacerTools[] blockPlacerToolsArray3 = new BlockPlacerTools[2];
            blockPlacerToolsArray3[0] = BlockPlacerTools.Replace;
            blockPlacerToolsArray = blockPlacerToolsArray3;
            blockPlacerToolsArray3[1] = BlockPlacerTools.Clear;
        }
        return blockPlacerToolsArray;
    }

    @Override
    public boolean hasPlacementOptions() {
        return false;
    }

    @Override
    public boolean hasConnectivityOptions() {
        return true;
    }

    @Override
    int getMax(int paramIndex) {
        return 10;
    }

    @Override
    int getMin(int paramIndex) {
        return 1;
    }

    @Override
    public BlockPlacerTools redirectTool(BlockPlacerTools tool) {
        if (tool == BlockPlacerTools.Overlay) {
            return BlockPlacerTools.Place;
        }
        return super.redirectTool(tool);
    }

    @Override
    public Collection<BlockPos> addToGlobalPositions(LevelAccessor world, BlockPos targetPos, Direction targetFace, Collection<BlockPos> affectedPositions, BlockPlacerTools usedTool) {
        boolean searchDiagonals = this.param1 == 0;
        boolean fuzzy = this.param2 == 0;
        boolean replace = usedTool != BlockPlacerTools.Overlay;
        int searchRange = this.param0;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        BlockState state = world.m_8055_(targetPos);
        LinkedList<BlockPos> offsets = new LinkedList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) >= 2 && !searchDiagonals || targetFace.m_122434_().m_7863_(x, y, z) != 0 && this.surface) continue;
                    offsets.add(new BlockPos(x, y, z));
                }
            }
        }
        BlockPos startPos = replace ? targetPos : targetPos.m_121945_(targetFace);
        frontier.add(startPos);
        while (!frontier.isEmpty()) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!currentPos.m_123314_((Vec3i)startPos, (double)searchRange)) continue;
            if (replace) {
                BlockState stateToReplace = world.m_8055_(currentPos);
                BlockState stateAboveStateToReplace = world.m_8055_(currentPos.m_121945_(targetFace));
                if (stateToReplace.m_60800_((BlockGetter)world, currentPos) == -1.0f || stateToReplace.m_60734_() != state.m_60734_() && !fuzzy || stateToReplace.m_247087_() || BlockHelper.hasBlockSolidSide((BlockState)stateAboveStateToReplace, (BlockGetter)world, (BlockPos)currentPos.m_121945_(targetFace), (Direction)targetFace.m_122424_()) && this.surface) continue;
                affectedPositions.add(currentPos);
                for (BlockPos offset : offsets) {
                    frontier.add(currentPos.m_121955_((Vec3i)offset));
                }
                continue;
            }
            BlockState stateToPlaceAt = world.m_8055_(currentPos);
            BlockState stateToPlaceOn = world.m_8055_(currentPos.m_121945_(targetFace.m_122424_()));
            if (stateToPlaceOn.m_247087_() || stateToPlaceOn.m_60734_() != state.m_60734_() && !fuzzy || !stateToPlaceAt.m_247087_()) continue;
            affectedPositions.add(currentPos);
            for (BlockPos offset : offsets) {
                frontier.add(currentPos.m_121955_((Vec3i)offset));
            }
        }
        return affectedPositions;
    }
}

