/*
 * Decompiled with CFR 0.152.
 */
package net.stalosir.createkart;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigCreateKart {
    public static final ForgeConfigSpec SERVER_SPECS;
    public static final Server SERVER;
    public static final ForgeConfigSpec CLIENT_SPECS;
    public static final Client CLIENT;
    public static double CONFIG_MOVEMENT_SPEED;
    public static double CONFIG_ROTATION_STRENGTH;
    public static double CONFIG_MAX_UP_STEP;
    public static boolean OLD_MOVEMENT_CHECK;
    public static double CONFIG_FUEL_CONSUMPTION;
    public static boolean MINIMAL_OVERLAY_CHECK;

    static {
        CONFIG_MOVEMENT_SPEED = 0.25;
        CONFIG_ROTATION_STRENGTH = 3.0;
        CONFIG_MAX_UP_STEP = 1.0;
        OLD_MOVEMENT_CHECK = false;
        CONFIG_FUEL_CONSUMPTION = 5.0;
        MINIMAL_OVERLAY_CHECK = false;
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPECS = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPECS = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static class Server {
        public Server(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Double> Config_Movement_Speed;
        public final ForgeConfigSpec.ConfigValue<Double> Config_Rotation_Strength;
        public final ForgeConfigSpec.ConfigValue<Double> Config_Max_Up_Step;
        public ForgeConfigSpec.BooleanValue Old_Movement_Check;
        public final ForgeConfigSpec.ConfigValue<Double> Config_Fuel_Consumption;
        public ForgeConfigSpec.BooleanValue Minimal_Overlay_Check;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("General Settings");
            this.Config_Movement_Speed = builder.comment("Defines the maximum speed of the kart. (Default value: 0.25)").define("Mouvement Speed", (Object)0.25);
            this.Config_Rotation_Strength = builder.comment("Defines the rotational force of the kart. (Default value: 3.0)").define("Rotation Streng", (Object)3.0);
            this.Config_Max_Up_Step = builder.comment("Define the number of blocks that will be climbed by the kart. (Default value: 1.0)").define("Max Up Step", (Object)1.0);
            builder.pop();
            builder.push("Movement Settings");
            this.Old_Movement_Check = builder.comment("changes the way the kart is steered for old movements before 2.0").comment("be careful if this parameter is set to true, the left and right animations of the kart are deactivated because they are useless").comment("(true = Old movement / false = New movement)").define("Old Movement", false);
            builder.pop();
            builder.push("Fuel Settings");
            this.Config_Fuel_Consumption = builder.comment("Define the fuel consumption for a traveling 1 block. (Default value: 5.0)").comment("    [Preview setting stats]").comment("     WARN: NOT EXACT AMOUNT").comment("").comment("  Consumption          Traveled").comment("1.0 fuel/block   ->  22000 block").comment("2.0 fuel/block   ->  11000 block").comment("4.0 fuel/block   ->   5500 block").comment("5.0 fuel/block   ->   4400 block (default)").comment("10.0 fuel/block  ->   2200 block").comment("15.0 fuel/block  ->   1650 block").comment("20.0 fuel/block  ->   1100 block").comment("").define("Fuel Consumption", (Object)5.0);
            this.Minimal_Overlay_Check = builder.comment("Changes the fuel overlay display to a minimal version").comment("WARN: Only the fuel shortage popup is affected by this setting, the coal bar and the value below it do not change.").comment("(true = Minimal Overlay / false = Default Overlay)").define("Minimal Overlay", false);
            builder.pop();
        }

        public double getConfigMovementSpeed() {
            return (Double)this.Config_Movement_Speed.get();
        }

        public double getConfigRotationStrength() {
            return (Double)this.Config_Rotation_Strength.get();
        }

        public double getConfigMaxUpStep() {
            return (Double)this.Config_Max_Up_Step.get();
        }

        public boolean getOldMovementCheck() {
            return (Boolean)this.Old_Movement_Check.get();
        }

        public double getConfigFuelConsumption() {
            return (Double)this.Config_Fuel_Consumption.get();
        }

        public boolean getMinimalOverlayCheck() {
            return (Boolean)this.Minimal_Overlay_Check.get();
        }
    }
}

